/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.internal.InternalInspection;

public class UseVirtualFileEqualsInspection
extends InternalInspection {
    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/UseVirtualFileEqualsInspection", "buildInternalVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/idea/devkit/inspections/internal/UseVirtualFileEqualsInspection$1", "visitBinaryExpression"));
                }
                super.visitBinaryExpression(expression);
                if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression)) {
                    return;
                }
                PsiExpression lhs = expression.getLOperand();
                PsiExpression rhs = expression.getROperand();
                if (rhs == null || lhs.textMatches((CharSequence)"null") || rhs.textMatches((CharSequence)"null") || lhs.textMatches((CharSequence)"this") || rhs.textMatches((CharSequence)"this")) {
                    return;
                }
                if (InheritanceUtil.isInheritor((PsiType)lhs.getType(), (String)VirtualFile.class.getName()) || InheritanceUtil.isInheritor((PsiType)rhs.getType(), (String)VirtualFile.class.getName())) {
                    holder.registerProblem((PsiElement)expression, "VirtualFile objects should be compared by equals(), not ==", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        };
    }
}

