/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.internal.reflect.MethodDescription;
import org.gradle.model.Managed;
import org.gradle.model.Unmanaged;
import org.gradle.model.internal.manage.schema.ManagedImplModelSchema;
import org.gradle.model.internal.manage.schema.ModelCollectionSchema;
import org.gradle.model.internal.manage.schema.ModelManagedImplStructSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelValueSchema;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.ModelPropertyExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspect;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractor;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaUtils;
import org.gradle.model.internal.manage.schema.extract.PropertyAccessorExtractionContext;
import org.gradle.model.internal.manage.schema.extract.StructSchemaExtractionStrategySupport;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedImplStructStrategy
extends StructSchemaExtractionStrategySupport {
    protected ManagedImplStructStrategy(ModelSchemaAspectExtractor aspectExtractor) {
        super(aspectExtractor);
    }

    @Override
    protected boolean isTarget(ModelType<?> type) {
        return type.getRawClass().isAnnotationPresent(Managed.class);
    }

    @Override
    protected <R> void validateTypeHierarchy(final ModelSchemaExtractionContext<R> extractionContext, ModelType<R> type) {
        ModelSchemaUtils.walkTypeHierarchy(type.getConcreteClass(), new ModelSchemaUtils.TypeVisitor<R>(){

            @Override
            public void visitType(Class<? super R> type) {
                if (type.isAnnotationPresent(Managed.class)) {
                    ManagedImplStructStrategy.this.validateManagedType(extractionContext, type);
                }
            }
        });
    }

    @Override
    protected void handleOverloadedMethods(ModelSchemaExtractionContext<?> extractionContext, Collection<Method> overloadedMethods) {
        if (ModelSchemaUtils.isMethodDeclaredInManagedType(overloadedMethods)) {
            throw this.invalidMethods(extractionContext, "overloaded methods are not supported", overloadedMethods);
        }
    }

    @Override
    protected ModelProperty.StateManagementType determineStateManagementType(ModelSchemaExtractionContext<?> extractionContext, PropertyAccessorExtractionContext getterContext) {
        if (getterContext.getMostSpecificDeclaration().getName().equals("getName") && Named.class.isAssignableFrom(extractionContext.getType().getRawClass())) {
            return ModelProperty.StateManagementType.MANAGED;
        }
        if (getterContext.isDeclaredInManagedType()) {
            if (getterContext.isDeclaredAsAbstract()) {
                return ModelProperty.StateManagementType.MANAGED;
            }
            return ModelProperty.StateManagementType.UNMANAGED;
        }
        return ModelProperty.StateManagementType.UNMANAGED;
    }

    protected <R> ModelManagedImplStructSchema<R> createSchema(ModelSchemaExtractionContext<R> extractionContext, Iterable<ModelPropertyExtractionResult<?>> propertyResults, Iterable<ModelSchemaAspect> aspects) {
        ModelType<R> type = extractionContext.getType();
        Iterable properties = Iterables.transform(propertyResults, (Function)new Function<ModelPropertyExtractionResult<?>, ModelProperty<?>>(){

            public ModelProperty<?> apply(ModelPropertyExtractionResult<?> propertyResult) {
                return propertyResult.getProperty();
            }
        });
        return new ModelManagedImplStructSchema<R>(type, properties, aspects);
    }

    @Override
    protected void handleInvalidGetter(ModelSchemaExtractionContext<?> extractionContext, Method getter, String message) {
        if (ModelSchemaUtils.isMethodDeclaredInManagedType(getter)) {
            throw this.invalidMethod(extractionContext, message, getter);
        }
    }

    @Override
    protected void validateSetter(ModelSchemaExtractionContext<?> extractionContext, ModelType<?> propertyType, PropertyAccessorExtractionContext getterContext, PropertyAccessorExtractionContext setterContext) {
        Method mostSpecificSetter = setterContext.getMostSpecificDeclaration();
        if (!getterContext.isDeclaredAsAbstract() && setterContext.isDeclaredAsAbstract()) {
            throw this.invalidMethod(extractionContext, "setters are not allowed for non-abstract getters", mostSpecificSetter);
        }
        if (mostSpecificSetter.getName().equals("setName") && Named.class.isAssignableFrom(extractionContext.getType().getRawClass())) {
            throw new InvalidManagedModelElementTypeException(extractionContext, String.format("@Managed types implementing %s must not declare a setter for the name property", Named.class.getName()));
        }
        if (getterContext.isDeclaredInManagedType() && !setterContext.isDeclaredInManagedType()) {
            throw this.invalidMethods(extractionContext, "unmanaged setter for managed getter", Iterables.concat(getterContext.getDeclaringMethods(), setterContext.getDeclaringMethods()));
        }
        if (!getterContext.isDeclaredInManagedType() && setterContext.isDeclaredInManagedType()) {
            throw this.invalidMethods(extractionContext, "managed setter for unmanaged getter", Iterables.concat(getterContext.getDeclaringMethods(), setterContext.getDeclaringMethods()));
        }
        if (!setterContext.isDeclaredInManagedType()) {
            return;
        }
        if (!Modifier.isAbstract(mostSpecificSetter.getModifiers())) {
            throw this.invalidMethod(extractionContext, "non-abstract setters are not allowed", mostSpecificSetter);
        }
        if (!mostSpecificSetter.getReturnType().equals(Void.TYPE)) {
            throw this.invalidMethod(extractionContext, "setter method must have void return type", mostSpecificSetter);
        }
        Type[] setterParameterTypes = mostSpecificSetter.getGenericParameterTypes();
        if (setterParameterTypes.length != 1) {
            throw this.invalidMethod(extractionContext, "setter method must have exactly one parameter", mostSpecificSetter);
        }
        ModelType setterType = ModelType.paramType(mostSpecificSetter, 0);
        if (!setterType.equals(propertyType)) {
            String message = "setter method param must be of exactly the same type as the getter returns (expected: " + propertyType + ", found: " + setterType + ")";
            throw this.invalidMethod(extractionContext, message, mostSpecificSetter);
        }
    }

    @Override
    protected void validateAllNecessaryMethodsHandled(ModelSchemaExtractionContext<?> extractionContext, Collection<Method> allMethods, final Set<Method> handledMethods) {
        Iterable notHandled = Iterables.filter(allMethods, (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                return method.getDeclaringClass().isAnnotationPresent(Managed.class) && !handledMethods.contains(method);
            }
        });
        if (!Iterables.isEmpty((Iterable)notHandled)) {
            throw this.invalidMethods(extractionContext, "only paired getter/setter methods are supported", notHandled);
        }
    }

    @Override
    protected <P> Action<ModelSchema<P>> createPropertyValidator(final ModelSchemaExtractionContext<?> parentContext, final ModelPropertyExtractionResult<P> propertyResult) {
        return new Action<ModelSchema<P>>(){

            public void execute(ModelSchema<P> propertySchema) {
                ModelProperty property = propertyResult.getProperty();
                if (!property.getStateManagementType().equals((Object)ModelProperty.StateManagementType.MANAGED)) {
                    return;
                }
                if (property.getName().equals("name") && Named.class.isAssignableFrom(parentContext.getType().getRawClass())) {
                    return;
                }
                boolean isAllowedPropertyTypeOfManagedType = propertySchema instanceof ManagedImplModelSchema || propertySchema instanceof ModelValueSchema;
                boolean isDeclaredAsHavingUnmanagedType = propertyResult.getGetter().isAnnotationPresent(Unmanaged.class);
                if (isAllowedPropertyTypeOfManagedType && isDeclaredAsHavingUnmanagedType) {
                    throw new InvalidManagedModelElementTypeException(parentContext, String.format("property '%s' is marked as @Unmanaged, but is of @Managed type '%s'. Please remove the @Managed annotation.%n", property.getName(), property.getType()));
                }
                if (!property.isWritable() && isDeclaredAsHavingUnmanagedType) {
                    throw new InvalidManagedModelElementTypeException(parentContext, String.format("unmanaged property '%s' cannot be read only, unmanaged properties must have setters", property.getName()));
                }
                if (propertySchema instanceof ModelCollectionSchema && !(propertySchema instanceof ScalarCollectionSchema) && property.isWritable()) {
                    throw new InvalidManagedModelElementTypeException(parentContext, String.format("property '%s' cannot have a setter (%s properties must be read only).", property.getName(), property.getType().toString()));
                }
            }
        };
    }

    private void validateManagedType(ModelSchemaExtractionContext<?> extractionContext, Class<?> typeClass) {
        if (!typeClass.isInterface() && !Modifier.isAbstract(typeClass.getModifiers())) {
            throw new InvalidManagedModelElementTypeException(extractionContext, "must be defined as an interface or an abstract class.");
        }
        if (typeClass.getTypeParameters().length > 0) {
            throw new InvalidManagedModelElementTypeException(extractionContext, "cannot be a parameterized type.");
        }
        Constructor<?> customConstructor = this.findCustomConstructor(typeClass);
        if (customConstructor != null) {
            throw this.invalidMethod(extractionContext, "custom constructors are not allowed", customConstructor);
        }
        this.ensureNoInstanceScopedFields(extractionContext, typeClass);
        this.ensureNoProtectedOrPrivateMethods(extractionContext, typeClass);
    }

    private void ensureNoProtectedOrPrivateMethods(ModelSchemaExtractionContext<?> extractionContext, Class<?> typeClass) {
        Iterable protectedAndPrivateMethods;
        Class<?> superClass = typeClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.ensureNoProtectedOrPrivateMethods(extractionContext, superClass);
        }
        if (!Iterables.isEmpty((Iterable)(protectedAndPrivateMethods = Iterables.filter(Arrays.asList(typeClass.getDeclaredMethods()), (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                int modifiers = method.getModifiers();
                return !method.isSynthetic() && (Modifier.isProtected(modifiers) || Modifier.isPrivate(modifiers));
            }
        })))) {
            throw this.invalidMethods(extractionContext, "protected and private methods are not allowed", protectedAndPrivateMethods);
        }
    }

    private void ensureNoInstanceScopedFields(ModelSchemaExtractionContext<?> extractionContext, Class<?> typeClass) {
        List<Field> declaredFields;
        Iterable instanceScopedFields;
        ImmutableSortedSet sortedDescriptions;
        Class<?> superClass = typeClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.ensureNoInstanceScopedFields(extractionContext, superClass);
        }
        if (!(sortedDescriptions = ImmutableSortedSet.copyOf((Iterable)Iterables.transform((Iterable)(instanceScopedFields = Iterables.filter(declaredFields = Arrays.asList(typeClass.getDeclaredFields()), (Predicate)new Predicate<Field>(){

            public boolean apply(Field field) {
                return !Modifier.isStatic(field.getModifiers()) && !field.getName().equals("metaClass");
            }
        })), (Function)new Function<Field, String>(){

            public String apply(Field field) {
                return field.toString();
            }
        }))).isEmpty()) {
            throw new InvalidManagedModelElementTypeException(extractionContext, "instance scoped fields are not allowed (found fields: " + Joiner.on((String)", ").join((Iterable)sortedDescriptions) + ").");
        }
    }

    private Constructor<?> findCustomConstructor(Class<?> typeClass) {
        Constructor<?> customSuperConstructor;
        Class<?> superClass = typeClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class) && (customSuperConstructor = this.findCustomConstructor(typeClass.getSuperclass())) != null) {
            return customSuperConstructor;
        }
        Constructor<?>[] constructors = typeClass.getConstructors();
        if (constructors.length == 0 || constructors.length == 1 && constructors[0].getParameterTypes().length == 0) {
            return null;
        }
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length <= 0) continue;
            return constructor;
        }
        throw new RuntimeException(String.format("Expected a constructor taking at least one argument in %s but no such constructors were found", typeClass.getName()));
    }

    private InvalidManagedModelElementTypeException invalidMethod(ModelSchemaExtractionContext<?> extractionContext, String message, Method method) {
        return this.invalidMethod(extractionContext, message, MethodDescription.of((Method)method));
    }

    private InvalidManagedModelElementTypeException invalidMethod(ModelSchemaExtractionContext<?> extractionContext, String message, Constructor<?> constructor) {
        return this.invalidMethod(extractionContext, message, MethodDescription.of(constructor));
    }

    private InvalidManagedModelElementTypeException invalidMethod(ModelSchemaExtractionContext<?> extractionContext, String message, MethodDescription methodDescription) {
        return new InvalidManagedModelElementTypeException(extractionContext, message + " (invalid method: " + methodDescription.toString() + ").");
    }

    private InvalidManagedModelElementTypeException invalidMethods(ModelSchemaExtractionContext<?> extractionContext, String message, Iterable<Method> methods) {
        ImmutableSortedSet descriptions = ImmutableSortedSet.copyOf((Iterable)Iterables.transform(methods, (Function)new Function<Method, String>(){

            public String apply(Method method) {
                return MethodDescription.of((Method)method).toString();
            }
        }));
        return new InvalidManagedModelElementTypeException(extractionContext, message + " (invalid methods: " + Joiner.on((String)", ").join((Iterable)descriptions) + ").");
    }
}

