/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.THash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongObjectProcedure;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;

public class TLongObjectHashMap<V>
extends THash
implements TLongHashingStrategy {
    protected transient V[] _values;
    protected transient long[] _set;
    protected final TLongHashingStrategy _hashingStrategy = this;

    public TLongObjectHashMap() {
    }

    public TLongObjectHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public TLongObjectHashMap<V> clone() {
        TLongObjectHashMap m = (TLongObjectHashMap)super.clone();
        m._values = (Object[])this._values.clone();
        m._set = (long[])this._set.clone();
        return m;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        this._set = new long[capacity];
        return capacity;
    }

    public boolean contains(long val) {
        return this.index(val) >= 0;
    }

    @Override
    protected int capacity() {
        return this._values.length;
    }

    public V put(long key, V value) {
        boolean wasFree = false;
        V previous = null;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = TLongObjectHashMap.unwrapNull(this._values[index2]);
            isNewMapping = false;
        } else {
            wasFree = TLongObjectHashMap.isFree(this._values, index2);
        }
        this._set[index2] = key;
        this._values[index2] = TLongObjectHashMap.wrapNull(value);
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        long[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new long[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(oldVals, i)) continue;
            long o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
        }
    }

    public V get(long key) {
        int index2 = this.index(key);
        return index2 < 0 ? null : (V)TLongObjectHashMap.unwrapNull(this._values[index2]);
    }

    private static <V> V unwrapNull(V value) {
        return value == TObjectHash.NULL ? null : (V)value;
    }

    private static <V> V wrapNull(V value) {
        return (V)(value == null ? TObjectHash.NULL : value);
    }

    @Override
    public void clear() {
        super.clear();
        long[] keys = this._set;
        V[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0L;
            values[i] = null;
        }
    }

    protected int index(long val) {
        long[] set = this._set;
        Object[] values = this._values;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (!TLongObjectHashMap.isFree(values, index2) && (TLongObjectHashMap.isRemoved(values, index2) || set[index2] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while (!TLongObjectHashMap.isFree(values, index2) && (TLongObjectHashMap.isRemoved(values, index2) || set[index2] != val));
        }
        return TLongObjectHashMap.isFree(values, index2) ? -1 : index2;
    }

    protected int insertionIndex(long val) {
        int firstRemoved;
        Object[] values = this._values;
        long[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (TLongObjectHashMap.isFree(values, index2)) {
            return index2;
        }
        if (TLongObjectHashMap.isFull(values, index2) && set[index2] == val) {
            return -index2 - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = TLongObjectHashMap.isRemoved(values, index2) ? index2 : -1;
        do {
            if ((index2 -= probe) < 0) {
                index2 += length;
            }
            if (firstRemoved != -1 || !TLongObjectHashMap.isRemoved(values, index2)) continue;
            firstRemoved = index2;
        } while (TLongObjectHashMap.isFull(values, index2) && set[index2] != val);
        if (TLongObjectHashMap.isRemoved(values, index2)) {
            while (!TLongObjectHashMap.isFree(values, index2) && (TLongObjectHashMap.isRemoved(values, index2) || set[index2] != val)) {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            }
        }
        if (TLongObjectHashMap.isFull(values, index2)) {
            return -index2 - 1;
        }
        return firstRemoved == -1 ? index2 : firstRemoved;
    }

    static boolean isFull(Object[] values, int index2) {
        Object value = values[index2];
        return value != null && value != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values, int index2) {
        return values[index2] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values, int index2) {
        return values[index2] == null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TLongObjectHashMap)) {
            return false;
        }
        TLongObjectHashMap that = (TLongObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index2) {
        this._values[index2] = TObjectHash.REMOVED;
        super.removeAt(index2);
    }

    public boolean forEachEntry(TLongObjectProcedure<V> procedure) {
        long[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(values, i) || procedure.execute(keys[i], TLongObjectHashMap.unwrapNull(values[i]))) continue;
            return false;
        }
        return true;
    }

    public void transformValues(TObjectFunction<V, V> function) {
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(values, i)) continue;
            values[i] = TLongObjectHashMap.wrapNull(function.execute(TLongObjectHashMap.unwrapNull(values[i])));
        }
    }

    @Override
    public final int computeHashCode(long val) {
        return HashFunctions.hash(val);
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TLongObjectProcedure<V>(){

            @Override
            public boolean execute(long key, V value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append((Object)(value == this ? "(this Map)" : value));
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure<V>
    implements TLongObjectProcedure<V> {
        private final TLongObjectHashMap<V> _otherMap;

        EqProcedure(TLongObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(long key, V value) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    private final class HashProcedure
    implements TLongObjectProcedure<V> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(long key, V value) {
            this.h += TLongObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

