/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.lang.Language;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.KtLightMethod;

public class LightParameterListBuilder
extends LightElement
implements PsiParameterList {
    private final List<PsiParameter> myParameters = new ArrayList<PsiParameter>();
    private final KtLightMethod parent;
    private PsiParameter[] myCachedParameters;

    public LightParameterListBuilder(PsiManager manager, Language language, KtLightMethod parent2) {
        super(manager, language);
        this.parent = parent2;
    }

    public void addParameter(PsiParameter parameter) {
        this.myParameters.add(parameter);
        this.myCachedParameters = null;
    }

    @Override
    public KtLightMethod getParent() {
        return this.parent;
    }

    @Override
    public String toString() {
        return "Light parameter list";
    }

    @Override
    @NotNull
    public PsiParameter[] getParameters() {
        if (this.myCachedParameters == null) {
            this.myCachedParameters = this.myParameters.isEmpty() ? PsiParameter.EMPTY_ARRAY : this.myParameters.toArray(new PsiParameter[this.myParameters.size()]);
        }
        if (this.myCachedParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/LightParameterListBuilder", "getParameters"));
        }
        return this.myCachedParameters;
    }

    @Override
    public int getParameterIndex(PsiParameter parameter) {
        return this.myParameters.indexOf(parameter);
    }

    @Override
    public int getParametersCount() {
        return this.myParameters.size();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/asJava/LightParameterListBuilder", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameterList(this);
        }
    }
}

