/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.DeadCodeEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.MandatoryMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantGotoMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxingMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantNullCheckMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class OptimizationMethodVisitor
extends MethodVisitor {
    private static final MethodTransformer MANDATORY_METHOD_TRANSFORMER = new MandatoryMethodTransformer();
    private static final MethodTransformer[] OPTIMIZATION_TRANSFORMERS = new MethodTransformer[]{new RedundantNullCheckMethodTransformer(), new RedundantBoxingMethodTransformer(), new DeadCodeEliminationMethodTransformer(), new RedundantGotoMethodTransformer()};
    private final MethodNode methodNode;
    private final MethodVisitor delegate;
    private final boolean disableOptimization;

    public OptimizationMethodVisitor(@NotNull MethodVisitor delegate2, boolean disableOptimization, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor", "<init>"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor", "<init>"));
        }
        super(327680);
        this.delegate = delegate2;
        this.methodNode = new MethodNode(access, name, desc, signature, exceptions);
        this.methodNode.localVariables = new ArrayList<LocalVariableNode>(5);
        this.mv = InlineCodegenUtil.wrapWithMaxLocalCalc(this.methodNode);
        this.disableOptimization = disableOptimization;
    }

    @Override
    public void visitEnd() {
        if (this.methodNode.maxLocals <= 0 || this.methodNode.maxStack <= 0) {
            this.mv.visitMaxs(-1, -1);
        }
        super.visitEnd();
        if (OptimizationMethodVisitor.shouldBeTransformed(this.methodNode)) {
            MANDATORY_METHOD_TRANSFORMER.transform("fake", this.methodNode);
            if (OptimizationMethodVisitor.canBeOptimized(this.methodNode) && !this.disableOptimization) {
                for (MethodTransformer transformer : OPTIMIZATION_TRANSFORMERS) {
                    transformer.transform("fake", this.methodNode);
                }
            }
            UtilKt.prepareForEmitting(this.methodNode);
        }
        this.methodNode.accept(new EndIgnoringMethodVisitorDecorator(327680, this.delegate));
        if (this.methodNode.instructions.size() == 0) {
            List<LocalVariableNode> localVariables = this.methodNode.localVariables;
            int n = localVariables == null ? 0 : localVariables.size();
            for (int i = 0; i < n; ++i) {
                localVariables.get(i).accept(this.delegate);
            }
        }
        this.delegate.visitEnd();
    }

    @Nullable
    public TraceMethodVisitor getTraceMethodVisitorIfPossible() {
        TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(new Textifier());
        try {
            this.methodNode.accept(traceMethodVisitor);
        }
        catch (Throwable e) {
            return null;
        }
        return traceMethodVisitor;
    }

    private static boolean shouldBeTransformed(@NotNull MethodNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor", "shouldBeTransformed"));
        }
        return node.instructions.size() > 0;
    }

    private static boolean canBeOptimized(@NotNull MethodNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor", "canBeOptimized"));
        }
        int totalFramesSizeMb = node.instructions.size() * (node.maxLocals + node.maxStack) / 0x100000;
        return totalFramesSizeMb < 50;
    }

    private static class EndIgnoringMethodVisitorDecorator
    extends MethodVisitor {
        public EndIgnoringMethodVisitorDecorator(int api, @NotNull MethodVisitor mv) {
            if (mv == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor$EndIgnoringMethodVisitorDecorator", "<init>"));
            }
            super(api, mv);
        }

        @Override
        public void visitEnd() {
        }
    }
}

