/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsName;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.utils.ManglingUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\f\u0010\u0016\u001a\u00020\u000b*\u00020\nH\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/js/translate/context/UsageTracker;", "", "parent", "containingDescriptor", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "scope", "Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;", "(Lorg/jetbrains/kotlin/js/translate/context/UsageTracker;Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;)V", "captured", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "capturedDescriptorToJsName", "", "getCapturedDescriptorToJsName", "()Ljava/util/Map;", "getContainingDescriptor", "()Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "captureIfNeed", "", "descriptor", "used", "getJsNameForCapturedDescriptor", "kotlin-compiler"})
public final class UsageTracker {
    private final LinkedHashMap<DeclarationDescriptor, JsName> captured;
    private final UsageTracker parent;
    @NotNull
    private final MemberDescriptor containingDescriptor;
    private final JsFunctionScope scope;

    @NotNull
    public final Map<DeclarationDescriptor, JsName> getCapturedDescriptorToJsName() {
        return this.captured;
    }

    public final void used(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (UsageTrackerKt.isCaptured(this, descriptor2)) {
            return;
        }
        if (descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual(((FunctionDescriptor)descriptor2).getVisibility(), Visibilities.LOCAL)) {
            Unit unit;
            boolean value$iv = !descriptor2.getName().isSpecial();
            if (_Assertions.ENABLED) {
                if (!value$iv) {
                    String message$iv = "Function with special name can not be captured, descriptor: " + descriptor2;
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof PropertyDescriptor)) {
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof ReceiverParameterDescriptor) {
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)descriptor2).isReified()) {
            this.captureIfNeed(descriptor2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void captureIfNeed(DeclarationDescriptor descriptor2) {
        void $receiver$iv;
        Unit unit;
        if (descriptor2 == null || UsageTrackerKt.isCaptured(this, descriptor2) || DescriptorUtils.isAncestor(this.containingDescriptor, descriptor2, true)) {
            return;
        }
        UsageTracker usageTracker = this.parent;
        if (usageTracker != null) {
            usageTracker.captureIfNeed(descriptor2);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        Map map2 = this.captured;
        JsName value$iv = this.getJsNameForCapturedDescriptor(descriptor2);
        $receiver$iv.put(descriptor2, value$iv);
    }

    private final JsName getJsNameForCapturedDescriptor(DeclarationDescriptor $receiver) {
        String string;
        DeclarationDescriptor declarationDescriptor = $receiver;
        if (declarationDescriptor instanceof ReceiverParameterDescriptor) {
            string = UsageTrackerKt.access$getNameForCapturedReceiver((ReceiverParameterDescriptor)$receiver);
        } else if (declarationDescriptor instanceof TypeParameterDescriptor) {
            String string2 = Namer.isInstanceSuggestedName((TypeParameterDescriptor)$receiver);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "Namer.isInstanceSuggestedName(this)");
        } else {
            String string3 = ManglingUtils.getSuggestedName($receiver);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "getSuggestedName(this)");
        }
        String suggestedName = string;
        JsName jsName = this.scope.declareFreshName(suggestedName);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "scope.declareFreshName(suggestedName)");
        return jsName;
    }

    @NotNull
    public final MemberDescriptor getContainingDescriptor() {
        return this.containingDescriptor;
    }

    public UsageTracker(@Nullable UsageTracker parent2, @NotNull MemberDescriptor containingDescriptor, @NotNull JsFunctionScope scope2) {
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        this.parent = parent2;
        this.containingDescriptor = containingDescriptor;
        this.scope = scope2;
        this.captured = MapsKt.linkedMapOf(new Pair[0]);
    }
}

