/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.branchConfig.CreateBranchOrTagDialog;
import org.jetbrains.idea.svn.checkin.IdeaCommitHandler;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.update.AutoSvnUpdater;
import org.jetbrains.idea.svn.update.SingleRootSwitcher;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CreateBranchOrTagAction
extends BasicAction {
    @Override
    protected String getActionName(AbstractVcs vcs) {
        return SvnBundle.message("action.Subversion.Copy.text", new Object[0]);
    }

    @Override
    protected boolean needsAllFiles() {
        return true;
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        if (file == null) {
            return false;
        }
        return SvnStatusUtil.isUnderControl(project, file);
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void perform(final Project project, final SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
        CreateBranchOrTagDialog dialog = new CreateBranchOrTagDialog(project, true, new File(file.getPath()));
        if (dialog.showAndGet()) {
            int rc;
            SVNURL parentUrl;
            SVNURL dstSvnUrl;
            SVNURL srcUrl;
            final String dstURL = dialog.getToURL();
            final SVNRevision revision = dialog.getRevision();
            final String comment = dialog.getComment();
            final Ref exception = new Ref();
            final boolean isSrcFile = dialog.isCopyFromWorkingCopy();
            final File srcFile = new File(dialog.getCopyFromPath());
            try {
                srcUrl = SVNURL.parseURIEncoded((String)dialog.getCopyFromUrl());
                dstSvnUrl = SVNURL.parseURIEncoded((String)dstURL);
                parentUrl = dstSvnUrl.removePathTail();
            }
            catch (SVNException e) {
                throw new SvnBindException(e);
            }
            if (!CreateBranchOrTagAction.dirExists(activeVcs, parentUrl) && (rc = Messages.showYesNoDialog((Project)project, (String)("The repository path '" + parentUrl + "' does not exist. Would you like to create it?"), (String)"Branch or Tag", (Icon)Messages.getQuestionIcon())) == 1) {
                return;
            }
            Runnable copyCommand = new Runnable(){

                @Override
                public void run() {
                    try {
                        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                        IdeaCommitHandler handler = null;
                        if (progress != null) {
                            progress.setText(SvnBundle.message("progress.text.copy.to", dstURL));
                            handler = new IdeaCommitHandler(progress);
                        }
                        SvnTarget source = isSrcFile ? SvnTarget.fromFile((File)srcFile, (SVNRevision)revision) : SvnTarget.fromURL((SVNURL)srcUrl, (SVNRevision)revision);
                        long newRevision = activeVcs.getFactory(source).createCopyMoveClient().copy(source, SvnTarget.fromURL((SVNURL)dstSvnUrl), revision, true, false, comment, handler);
                        CreateBranchOrTagAction.this.updateStatusBar(newRevision, project);
                    }
                    catch (Exception e) {
                        exception.set((Object)e);
                    }
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(copyCommand, SvnBundle.message("progress.title.copy", new Object[0]), false, project);
            if (!exception.isNull()) {
                throw new VcsException((Throwable)exception.get());
            }
            if (dialog.isCopyFromWorkingCopy() && dialog.isSwitchOnCreate()) {
                SingleRootSwitcher switcher = new SingleRootSwitcher(project, VcsUtil.getFilePath((File)srcFile, (boolean)srcFile.isDirectory()), dstSvnUrl);
                AutoSvnUpdater.run(switcher, SvnBundle.message("action.name.switch", new Object[0]));
            }
        }
    }

    private void updateStatusBar(long revision, Project project) {
        StatusBar statusBar;
        if (revision > 0L && (statusBar = WindowManager.getInstance().getStatusBar(project)) != null) {
            statusBar.setInfo(SvnBundle.message("status.text.comitted.revision", revision));
        }
    }

    private static boolean dirExists(final @NotNull SvnVcs vcs, final @NotNull SVNURL url) throws SvnBindException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/branchConfig/CreateBranchOrTagAction", "dirExists"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/branchConfig/CreateBranchOrTagAction", "dirExists"));
        }
        final Ref excRef = new Ref();
        final Ref resultRef = new Ref((Object)Boolean.TRUE);
        Runnable taskImpl = new Runnable(){

            @Override
            public void run() {
                try {
                    vcs.getInfo(url, SVNRevision.HEAD);
                }
                catch (SvnBindException e) {
                    if (e.contains(SVNErrorCode.RA_ILLEGAL_URL)) {
                        resultRef.set((Object)Boolean.FALSE);
                    }
                    excRef.set((Object)e);
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(taskImpl, "Checking target folder", true, vcs.getProject());
        } else {
            taskImpl.run();
        }
        if (!excRef.isNull()) {
            throw (SvnBindException)((Object)excRef.get());
        }
        return (Boolean)resultRef.get();
    }

    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] files, DataContext context) throws VcsException {
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }
}

