/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.EmptyChangelistBuilder;
import com.intellij.openapi.vcs.update.UpdatedFilesReverseSide;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class GatheringChangelistBuilder
extends EmptyChangelistBuilder {
    private static final Logger LOG = Logger.getInstance(GatheringChangelistBuilder.class);
    @NotNull
    private final Set<VirtualFile> myCheckSet;
    @NotNull
    private final List<Change> myChanges;
    @NotNull
    private final UpdatedFilesReverseSide myFiles;
    @NotNull
    private final SvnVcs myVcs;

    public GatheringChangelistBuilder(@NotNull SvnVcs vcs, @NotNull UpdatedFilesReverseSide files) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/integrate/GatheringChangelistBuilder", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/svn/integrate/GatheringChangelistBuilder", "<init>"));
        }
        this.myVcs = vcs;
        this.myFiles = files;
        this.myChanges = ContainerUtil.newArrayList();
        this.myCheckSet = ContainerUtil.newHashSet();
    }

    public void processChange(Change change, VcsKey vcsKey) {
        this.addChange(change);
    }

    public void processChangeInList(Change change, @Nullable ChangeList changeList, VcsKey vcsKey) {
        this.addChange(change);
    }

    public void processChangeInList(Change change, String changeListName, VcsKey vcsKey) {
        this.addChange(change);
    }

    public void removeRegisteredChangeFor(FilePath path) {
        Iterator<Change> iterator = this.myChanges.iterator();
        while (iterator.hasNext()) {
            VirtualFile vf;
            Change change = iterator.next();
            if (!path.equals(ChangesUtil.getFilePath((Change)change)) || (vf = path.getVirtualFile()) == null) continue;
            this.myCheckSet.remove(vf);
            iterator.remove();
            return;
        }
    }

    private void addChange(Change change) {
        FilePath path = ChangesUtil.getFilePath((Change)change);
        VirtualFile vf = path.getVirtualFile();
        if ((this.mergeInfoChanged(path.getIOFile()) || vf != null && this.myFiles.containsFile(vf)) && !this.myCheckSet.contains(vf)) {
            this.myCheckSet.add(vf);
            this.myChanges.add(change);
        }
    }

    private boolean mergeInfoChanged(File file) {
        SvnTarget target = SvnTarget.fromFile((File)file);
        try {
            PropertyValue current = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, SVNRevision.WORKING);
            PropertyValue base = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, SVNRevision.BASE);
            if (current != null) {
                return base == null || !Comparing.equal((Object)current, (Object)base);
            }
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        return false;
    }

    public boolean reportChangesOutsideProject() {
        return true;
    }

    @NotNull
    public List<Change> getChanges() {
        List<Change> list = this.myChanges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/GatheringChangelistBuilder", "getChanges"));
        }
        return list;
    }
}

