/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgFileRevisionLogParser;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgLogCommand {
    private static final Logger LOG = Logger.getInstance((String)HgLogCommand.class.getName());
    @NotNull
    private final Project myProject;
    @NotNull
    private HgVersion myVersion;
    private boolean myIncludeRemoved;
    private boolean myFollowCopies;
    private boolean myLogFile;
    private boolean myLargeFilesWithFollowSupported;

    public void setIncludeRemoved(boolean includeRemoved) {
        this.myIncludeRemoved = includeRemoved;
    }

    public void setFollowCopies(boolean followCopies) {
        this.myFollowCopies = followCopies;
    }

    public void setLogFile(boolean logFile) {
        this.myLogFile = logFile;
    }

    public HgLogCommand(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgLogCommand", "<init>"));
        }
        this.myLogFile = true;
        this.myLargeFilesWithFollowSupported = false;
        this.myProject = project;
        HgVcs vcs = HgVcs.getInstance(this.myProject);
        if (vcs == null) {
            LOG.info("Vcs couldn't be null for project");
            return;
        }
        this.myVersion = vcs.getVersion();
        this.myLargeFilesWithFollowSupported = this.myVersion.isLargeFilesWithFollowSupported();
    }

    public final List<HgFileRevision> execute(HgFile hgFile, int limit, boolean includeFiles) throws HgCommandException {
        return this.execute(hgFile, limit, includeFiles, null);
    }

    public final List<HgFileRevision> execute(HgFile hgFile, int limit, boolean includeFiles, @Nullable List<String> argsForCmd) throws HgCommandException {
        if (limit <= 0 && limit != -1 || hgFile == null) {
            return Collections.emptyList();
        }
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(includeFiles, this.myVersion);
        String template = HgChangesetUtil.makeTemplate(templates);
        FilePath originalFileName = HgUtil.getOriginalFileName(hgFile.toFilePath(), ChangeListManager.getInstance((Project)this.myProject));
        HgFile originalHgFile = new HgFile(hgFile.getRepo(), originalFileName);
        HgCommandResult result = this.execute(hgFile.getRepo(), template, limit, originalHgFile, argsForCmd);
        return HgHistoryUtil.getCommitRecords(this.myProject, result, new HgFileRevisionLogParser(this.myProject, originalHgFile, this.myVersion));
    }

    @Nullable
    public HgCommandResult execute(@NotNull VirtualFile repo, @NotNull String template, int limit, @Nullable HgFile hgFile, @Nullable List<String> argsForCmd) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgLogCommand", "execute"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/zmlx/hg4idea/command/HgLogCommand", "execute"));
        }
        LinkedList<String> arguments = new LinkedList<String>();
        if (!(!this.myIncludeRemoved || this.myFollowCopies && this.myLogFile)) {
            arguments.add("--removed");
        }
        if (this.myFollowCopies) {
            arguments.add("--follow");
            if (!this.myLargeFilesWithFollowSupported) {
                arguments.add("--config");
                arguments.add("extensions.largefiles=!");
            }
        }
        arguments.add("--template");
        arguments.add(template);
        if (limit != -1) {
            arguments.add("--limit");
            arguments.add(String.valueOf(limit));
        }
        if (argsForCmd != null) {
            arguments.addAll(argsForCmd);
        }
        if (this.myLogFile && hgFile != null) {
            arguments.add(hgFile.getRelativePath());
        }
        HgCommandExecutor commandExecutor = new HgCommandExecutor(this.myProject);
        commandExecutor.setOutputAlwaysSuppressed(true);
        return commandExecutor.executeInCurrentThread(repo, "log", arguments);
    }
}

