/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgLogCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.provider.HgDiffFromHistoryHandler;
import org.zmlx.hg4idea.util.HgUtil;

public class HgHistoryProvider
implements VcsHistoryProvider {
    private final Project myProject;

    public HgHistoryProvider(Project project) {
        this.myProject = project;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return VcsDependentHistoryComponents.createOnlyColumns((ColumnInfo[])new ColumnInfo[0]);
    }

    public AnAction[] getAdditionalActions(Runnable runnable) {
        return new AnAction[]{ShowAllAffectedGenericAction.getInstance(), ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction")};
    }

    public boolean isDateOmittable() {
        return false;
    }

    public String getHelpId() {
        return null;
    }

    public VcsHistorySession createSessionFor(FilePath filePath) throws VcsException {
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filePath);
        if (vcsRoot == null) {
            return null;
        }
        ArrayList<VcsFileRevision> revisions = new ArrayList<VcsFileRevision>();
        revisions.addAll(HgHistoryProvider.getHistory(filePath, vcsRoot, this.myProject));
        return this.createAppendableSession(vcsRoot, revisions, null);
    }

    public void reportAppendableHistory(FilePath filePath, VcsAppendableHistorySessionPartner partner) throws VcsException {
        VirtualFile vcsRoot = HgUtil.getHgRootOrThrow(this.myProject, filePath);
        List<HgFileRevision> history = HgHistoryProvider.getHistory(filePath, vcsRoot, this.myProject);
        if (history.size() == 0) {
            return;
        }
        VcsAbstractHistorySession emptySession = this.createAppendableSession(vcsRoot, Collections.emptyList(), null);
        partner.reportCreatedEmptySession(emptySession);
        for (HgFileRevision hgFileRevision : history) {
            partner.acceptRevision((VcsFileRevision)hgFileRevision);
        }
        partner.finished();
    }

    private VcsAbstractHistorySession createAppendableSession(final VirtualFile vcsRoot, List<VcsFileRevision> revisions, @Nullable VcsRevisionNumber number) {
        return new VcsAbstractHistorySession(revisions, number){

            @Nullable
            protected VcsRevisionNumber calcCurrentRevisionNumber() {
                return new HgWorkingCopyRevisionsCommand(HgHistoryProvider.this.myProject).firstParent(vcsRoot);
            }

            public HistoryAsTreeProvider getHistoryAsTreeProvider() {
                return null;
            }

            public VcsHistorySession copy() {
                return HgHistoryProvider.this.createAppendableSession(vcsRoot, this.getRevisionList(), this.getCurrentRevisionNumber());
            }
        };
    }

    public static List<HgFileRevision> getHistory(@NotNull FilePath filePath, @NotNull VirtualFile vcsRoot, @NotNull Project project) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/zmlx/hg4idea/provider/HgHistoryProvider", "getHistory"));
        }
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "org/zmlx/hg4idea/provider/HgHistoryProvider", "getHistory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/HgHistoryProvider", "getHistory"));
        }
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)project);
        return HgHistoryProvider.getHistory(filePath, vcsRoot, project, null, vcsConfiguration.LIMIT_HISTORY ? vcsConfiguration.MAXIMUM_HISTORY_ROWS : -1);
    }

    public static List<HgFileRevision> getHistory(@NotNull FilePath filePath, @NotNull VirtualFile vcsRoot, @NotNull Project project, @Nullable HgRevisionNumber revisionNumber, int limit) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/zmlx/hg4idea/provider/HgHistoryProvider", "getHistory"));
        }
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "org/zmlx/hg4idea/provider/HgHistoryProvider", "getHistory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/HgHistoryProvider", "getHistory"));
        }
        HgLogCommand logCommand = new HgLogCommand(project);
        logCommand.setFollowCopies(!filePath.isDirectory());
        logCommand.setIncludeRemoved(true);
        ArrayList<String> args = new ArrayList<String>();
        String revNumberAsArg = revisionNumber == null ? "." : revisionNumber.getChangeset();
        args.add("--rev");
        args.add("reverse(0::" + revNumberAsArg + ")");
        try {
            return logCommand.execute(new HgFile(vcsRoot, filePath), limit, false, args);
        }
        catch (HgCommandException e) {
            new HgCommandResultNotifier(project).notifyError(null, HgVcsMessages.message("hg4idea.error.log.command.execution", new Object[0]), e.getMessage());
            return Collections.emptyList();
        }
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return new HgDiffFromHistoryHandler(this.myProject);
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/zmlx/hg4idea/provider/HgHistoryProvider", "canShowHistoryFor"));
        }
        return true;
    }
}

