/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.components;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RuntimeErrorReporter
implements ErrorReporter {
    public static final RuntimeErrorReporter INSTANCE;

    @Override
    public void reportIncompleteHierarchy(@NotNull ClassDescriptor descriptor2, @NotNull List<String> unresolvedSuperClasses) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(unresolvedSuperClasses, "unresolvedSuperClasses");
        throw (Throwable)new IllegalStateException("Incomplete hierarchy for class " + descriptor2.getName() + ", unresolved classes " + unresolvedSuperClasses);
    }

    @Override
    public void reportIncompatibleMetadataVersion(@NotNull ClassId classId, @NotNull String filePath, @NotNull BinaryVersion actualVersion) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        Intrinsics.checkParameterIsNotNull(actualVersion, "actualVersion");
        throw (Throwable)new IllegalStateException("Incompatible binary version of " + classId + ": " + actualVersion + " " + ("(expected version is " + JvmMetadataVersion.INSTANCE + ")"));
    }

    @Override
    public void reportCannotInferVisibility(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        throw (Throwable)new IllegalStateException("Cannot infer visibility for " + descriptor2);
    }

    @Override
    public void reportLoadingError(@NotNull String message, @Nullable Exception exception) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        throw (Throwable)new IllegalStateException(message, exception);
    }

    private RuntimeErrorReporter() {
        INSTANCE = this;
    }

    static {
        new RuntimeErrorReporter();
    }
}

