/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.BooleanEditor;
import com.intellij.uiDesigner.propertyInspector.properties.BindingProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IdentifierValidator;
import com.intellij.uiDesigner.propertyInspector.renderers.BooleanRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class CustomCreateProperty
extends Property<RadComponent, Boolean> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.propertyInspector.properties.CustomCreateProperty");
    private final BooleanRenderer myRenderer = new BooleanRenderer();
    private final BooleanEditor myEditor = new BooleanEditor(){

        @Override
        public JComponent getComponent(RadComponent component, Boolean value, InplaceContext inplaceContext) {
            JCheckBox result = (JCheckBox)super.getComponent(component, value, inplaceContext);
            boolean customCreateRequired = component.isCustomCreateRequired();
            if (customCreateRequired) {
                result.setEnabled(false);
                result.setSelected(true);
            } else {
                result.setEnabled(true);
            }
            return result;
        }
    };

    public static CustomCreateProperty getInstance(Project project) {
        return (CustomCreateProperty)ServiceManager.getService((Project)project, CustomCreateProperty.class);
    }

    public CustomCreateProperty() {
        super(null, "Custom Create");
    }

    @Override
    public Boolean getValue(RadComponent component) {
        return component.isCustomCreate();
    }

    @Override
    @NotNull
    public PropertyRenderer<Boolean> getRenderer() {
        BooleanRenderer booleanRenderer = this.myRenderer;
        if (booleanRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/CustomCreateProperty", "getRenderer"));
        }
        return booleanRenderer;
    }

    @Override
    public PropertyEditor<Boolean> getEditor() {
        return this.myEditor;
    }

    @Override
    public boolean appliesToSelection(List<RadComponent> selection) {
        if (selection.size() > 1) {
            for (RadComponent c : selection) {
                if (!c.isCustomCreateRequired()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void setValueImpl(RadComponent component, Boolean value) throws Exception {
        PsiClass aClass;
        IRootContainer root;
        if (value.booleanValue() && component.getBinding() == null) {
            String initialBinding = BindingProperty.getDefaultBinding(component);
            String binding = Messages.showInputDialog((Project)component.getProject(), (String)UIDesignerBundle.message("custom.create.field.name.prompt", new Object[0]), (String)UIDesignerBundle.message("custom.create.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)initialBinding, (InputValidator)new IdentifierValidator(component.getProject()));
            if (binding == null) {
                return;
            }
            try {
                new BindingProperty(component.getProject()).setValue(component, binding);
            }
            catch (Exception e1) {
                LOG.error((Throwable)e1);
            }
        }
        component.setCustomCreate(value);
        if (value.booleanValue() && (root = FormEditingUtil.getRoot(component)).getClassToBind() != null && Utils.getCustomCreateComponentCount((IContainer)root) == 1 && (aClass = FormEditingUtil.findClassToBind(component.getModule(), root.getClassToBind())) != null && FormEditingUtil.findCreateComponentsMethod(aClass) == null) {
            CustomCreateProperty.generateCreateComponentsMethod(aClass);
        }
    }

    public static void generateCreateComponentsMethod(final PsiClass aClass) {
        PsiFile psiFile = aClass.getContainingFile();
        if (psiFile == null) {
            return;
        }
        final VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
            return;
        }
        final Ref refMethod = new Ref();
        CommandProcessor.getInstance().executeCommand(aClass.getProject(), new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
                        try {
                            PsiMethod method = factory.createMethodFromText("private void createUIComponents() { \n // TODO: place custom component creation code here \n }", (PsiElement)aClass);
                            PsiMethod psiMethod = (PsiMethod)aClass.add((PsiElement)method);
                            refMethod.set((Object)SmartPointerManager.getInstance((Project)aClass.getProject()).createSmartPsiElementPointer((PsiElement)psiMethod));
                            CodeStyleManager.getInstance((Project)aClass.getProject()).reformat((PsiElement)psiMethod);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, null, null);
        if (!refMethod.isNull()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PsiMethod element = (PsiMethod)((SmartPsiElementPointer)refMethod.get()).getElement();
                    if (element != null) {
                        PsiCodeBlock body = element.getBody();
                        assert (body != null);
                        PsiComment comment = (PsiComment)PsiTreeUtil.getChildOfType((PsiElement)body, PsiComment.class);
                        if (comment != null) {
                            new OpenFileDescriptor(comment.getProject(), vFile, comment.getTextOffset()).navigate(true);
                        }
                    }
                }
            });
        }
    }
}

