/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.error;

import com.android.tools.idea.diagnostics.error.FeedbackSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class AnonymousFeedback {
    private static final String USER_AGENT = "User-Agent";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String HTTP_POST = "POST";
    private static final int HTTP_STATUS_OK_NO_CONTENT = 204;
    private static final String UA_STUDIO = "AndroidUIFIdeaDiagnostics/1.0";
    private static final String PROTOBUF_CONTENT = "application/x-protobuf";
    private static final String ANDROID_STUDIO_PRODUCT = "AndroidStudio";
    private static final String ANDROID_STUDIO_PACKAGE_NAME = "com.android.tools.idea";

    public static String sendFeedback(HttpConnectionFactory httpConnectionFactory, Throwable throwable, Map<String, String> map, String string, String string2, String string3) throws IOException {
        return AnonymousFeedback.sendFeedback(ANDROID_STUDIO_PRODUCT, ANDROID_STUDIO_PACKAGE_NAME, httpConnectionFactory, throwable, map, string, string2, string3);
    }

    public static String sendFeedback(String string, String string2, HttpConnectionFactory httpConnectionFactory, Throwable throwable, Map<String, String> map, String string3, String string4, String string5) throws IOException {
        byte[] byArray = FeedbackSerializer.serializeToMobileReport(string, string2, throwable, map, string3, string4, string5);
        AnonymousFeedback.sendFeedback(httpConnectionFactory, byArray);
        return Long.toString(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendFeedback(HttpConnectionFactory httpConnectionFactory, byte[] byArray) throws IOException {
        HttpURLConnection httpURLConnection = AnonymousFeedback.connect(httpConnectionFactory, "https://www.google.com/tools/feedback/mobile/__submit");
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod(HTTP_POST);
        httpURLConnection.setRequestProperty(USER_AGENT, UA_STUDIO);
        httpURLConnection.setRequestProperty(CONTENT_TYPE, PROTOBUF_CONTENT);
        OutputStream outputStream = httpURLConnection.getOutputStream();
        try {
            outputStream.write(byArray);
        }
        finally {
            outputStream.close();
        }
        int n = httpURLConnection.getResponseCode();
        if (n != 204) {
            throw new RuntimeException("Error submitting feedback: Expected HTTP_OK (204), obtained " + n);
        }
    }

    private static HttpURLConnection connect(HttpConnectionFactory httpConnectionFactory, String string) throws IOException {
        HttpURLConnection httpURLConnection = httpConnectionFactory.openHttpConnection(string);
        httpURLConnection.setConnectTimeout(2000);
        httpURLConnection.setReadTimeout(2000);
        return httpURLConnection;
    }

    public static class HttpConnectionFactory {
        protected HttpURLConnection openHttpConnection(String string) throws IOException {
            URL uRL = new URL(string);
            return (HttpURLConnection)uRL.openConnection();
        }
    }
}

