/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.XPathVariable;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.validation.ExpectedTypeUtil;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.refactoring.BaseIntroduceAction;
import org.intellij.lang.xpath.xslt.refactoring.RefactoringOptions;
import org.intellij.lang.xpath.xslt.refactoring.RefactoringUtil;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;

public class XsltExtractFunctionAction
extends BaseIntroduceAction<RefactoringOptions> {
    @Override
    public String getRefactoringName() {
        return "Extract Function";
    }

    @Override
    protected String getCommandName() {
        return "Extract XSLT Function";
    }

    @Override
    protected boolean actionPerformedImpl(PsiFile file, Editor editor, XmlAttribute context, int offset) {
        if (file.getLanguage() != XPathFileType.XPATH2.getLanguage()) {
            return false;
        }
        return super.actionPerformedImpl(file, editor, context, offset);
    }

    @Override
    protected boolean extractImpl(XPathExpression expression, Set<XPathExpression> matchingExpressions, List<XmlTag> otherMatches, RefactoringOptions dlg) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)expression, XmlAttribute.class, (boolean)true);
        assert (attribute != null);
        try {
            String name = dlg.getName();
            XmlTag rootTag = ((XmlFile)attribute.getParent().getContainingFile()).getRootTag();
            XmlTag[] templates = rootTag.findSubTags("template", "http://www.w3.org/1999/XSL/Transform");
            XmlTag insertionPoint = templates.length > 0 ? templates[0] : rootTag.getSubTags()[0];
            XmlTag parentTag = insertionPoint.getParentTag();
            assert (parentTag != null) : "Could not locate position to create function at";
            XmlTag xmlTag = parentTag.createChildTag("function", "http://www.w3.org/1999/XSL/Transform", null, false);
            xmlTag.setAttribute("name", name);
            XPathType type = ExpectedTypeUtil.mapType(expression, expression.getType());
            xmlTag.setAttribute("as", XsltExtractFunctionAction.prefixedName(type, insertionPoint));
            StringBuilder argList = new StringBuilder();
            List<XPathVariableReference> references = RefactoringUtil.collectVariableReferences(expression);
            for (XPathVariableReference reference : references) {
                XPathVariable variable = reference.resolve();
                if (!(variable instanceof XsltVariable) || XsltCodeInsightUtil.getTemplateTag(variable, false) == null) continue;
                XmlTag param = parentTag.createChildTag("param", "http://www.w3.org/1999/XSL/Transform", null, false);
                param.setAttribute("name", variable.getName());
                if (!variable.getType().isAbstract()) {
                    param.setAttribute("as", XsltExtractFunctionAction.prefixedName(ExpectedTypeUtil.mapType(expression, variable.getType()), parentTag));
                }
                RefactoringUtil.addParameter(xmlTag, param);
                if (argList.length() > 0) {
                    argList.append(", ");
                }
                argList.append("$").append(variable.getName());
            }
            XmlTag seqTag = parentTag.createChildTag("sequence", "http://www.w3.org/1999/XSL/Transform", null, false);
            seqTag.setAttribute("select", expression.getText());
            xmlTag.add((PsiElement)seqTag);
            PsiElement element = parentTag.addBefore((PsiElement)xmlTag, (PsiElement)insertionPoint);
            ASTNode node1 = parentTag.getNode();
            assert (node1 != null);
            ASTNode node2 = element.getNode();
            assert (node2 != null);
            CodeStyleManager.getInstance((Project)xmlTag.getManager().getProject()).reformatNewlyAddedElement(node1, node2);
            XPathExpression var = XPathChangeUtil.createExpression(expression, name + "(" + argList + ")");
            expression.replace(var);
            return true;
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
            return false;
        }
    }

    private static String prefixedName(XPathType type, XmlTag context) {
        String prefix;
        QName name;
        String uri;
        if (type instanceof XPath2Type && (uri = (name = ((XPath2Type)type).getQName()).getNamespaceURI()).length() > 0 && (prefix = context.getPrefixByNamespace(uri)) != null) {
            return prefix + ":" + name.getLocalPart();
        }
        return type.getName();
    }

    @Override
    protected RefactoringOptions getSettings(XPathExpression expression, Set<XPathExpression> matchingExpressions) {
        final String name = Messages.showInputDialog((Project)expression.getProject(), (String)"Function Name: ", (String)this.getRefactoringName(), (Icon)Messages.getQuestionIcon());
        final boolean[] b = new boolean[]{false};
        if (name != null) {
            String[] parts = name.split(":", 2);
            if (parts.length < 2) {
                Messages.showMessageDialog((Project)expression.getProject(), (String)"Custom functions require a prefixed name", (String)"Error", (Icon)Messages.getErrorIcon());
                b[0] = true;
            }
            XmlElement context = (XmlElement)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{XmlElement.class});
            NamespaceContext namespaceContext = expression.getXPathContext().getNamespaceContext();
            if (namespaceContext != null && context != null && namespaceContext.resolve(parts[0], context) == null) {
                Messages.showMessageDialog((Project)expression.getProject(), (String)("Prefix '" + parts[0] + "' is not defined"), (String)"Error", (Icon)Messages.getErrorIcon());
                b[0] = true;
            }
        }
        return new RefactoringOptions(){

            @Override
            public boolean isCanceled() {
                return b[0];
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }
}

