/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.DeviceDefinitionList;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import icons.AndroidIcons;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceDefinitionPreview
extends JPanel
implements DeviceDefinitionList.DeviceCategorySelectionListener {
    private static final String NO_DEVICE_SELECTED = "No Device Selected";
    private static final int FIGURE_PADDING = JBUI.scale((int)3);
    private static final DecimalFormat FORMAT = new DecimalFormat(".##\"");
    public static final int DIMENSION_LINE_WIDTH = JBUI.scale((int)1);
    public static final int OUTLINE_LINE_WIDTH = JBUI.scale((int)5);
    private Device myDevice;
    double myMaxOutlineHeight;
    double myMaxOutlineWidth;
    double myMinOutlineHeightIn;
    double myMinOutlineWidthIn;
    private static final int PADDING = JBUI.scale((int)20);
    private static final JBColor OUR_GRAY = new JBColor((Color)Gray._192, (Color)Gray._96);

    public void setDevice(@Nullable Device device) {
        this.myDevice = device;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        GraphicsUtil.setupAntialiasing((Graphics)g);
        GraphicsUtil.setupAAPainting((Graphics)g);
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(JBColor.background());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(JBColor.foreground());
        g2d.setFont(AvdWizardConstants.STANDARD_FONT);
        if (this.myDevice == null) {
            FontMetrics metrics = g2d.getFontMetrics();
            g2d.drawString(NO_DEVICE_SELECTED, (this.getWidth() - metrics.stringWidth(NO_DEVICE_SELECTED)) / 2, (this.getHeight() - metrics.getHeight()) / 2);
            return;
        }
        boolean isCircular = this.myDevice.isScreenRound();
        Icon icon = DeviceDefinitionPreview.getIcon(this.myDevice);
        icon.paintIcon(this, g, PADDING / 2, PADDING / 2);
        g2d.setFont(AvdWizardConstants.TITLE_FONT);
        FontMetrics metrics = g.getFontMetrics(AvdWizardConstants.TITLE_FONT);
        g2d.drawString(this.myDevice.getDisplayName(), JBUI.scale((int)50), PADDING + metrics.getHeight() / 2);
        g2d.drawLine(0, JBUI.scale((int)50), this.getWidth(), JBUI.scale((int)50));
        Dimension screenSize = this.getScaledDimension(this.myDevice);
        Dimension pixelScreenSize = this.myDevice.getScreenSize(this.myDevice.getDefaultState().getOrientation());
        if (screenSize != null) {
            Density pixelDensity;
            ScreenRatio ratio;
            int infoSegmentY;
            int infoSegmentX;
            if (screenSize.getHeight() <= 0.0) {
                screenSize.height = 1;
            }
            if (screenSize.getWidth() <= 0.0) {
                screenSize.width = 1;
            }
            RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(PADDING, JBUI.scale((int)100), screenSize.width, screenSize.height, JBUI.scale((int)10), JBUI.scale((int)10));
            g2d.setStroke(new BasicStroke(DIMENSION_LINE_WIDTH));
            g2d.setColor((Color)OUR_GRAY);
            g2d.setFont(AvdWizardConstants.FIGURE_FONT);
            metrics = g2d.getFontMetrics(AvdWizardConstants.FIGURE_FONT);
            int stringHeight = metrics.getHeight() - metrics.getDescent();
            String widthString = Integer.toString(pixelScreenSize.width) + "px";
            int widthLineY = JBUI.scale((int)95) - (metrics.getHeight() - metrics.getDescent()) / 2;
            g2d.drawLine(PADDING, widthLineY, DeviceDefinitionPreview.round(PADDING + screenSize.width), widthLineY);
            g2d.setColor(JBColor.background());
            int widthStringWidth = metrics.stringWidth(widthString);
            int widthTextX = DeviceDefinitionPreview.round(PADDING + (screenSize.width - widthStringWidth) / 2);
            g2d.drawLine(widthTextX - FIGURE_PADDING, widthLineY, widthTextX + widthStringWidth + FIGURE_PADDING, widthLineY);
            g2d.setColor(JBColor.foreground());
            g2d.drawString(widthString, widthTextX, JBUI.scale((int)95));
            g2d.setColor((Color)OUR_GRAY);
            String heightString = Integer.toString(pixelScreenSize.height) + "px";
            int heightLineX = DeviceDefinitionPreview.round(PADDING + screenSize.width + JBUI.scale((int)15));
            g2d.drawLine(heightLineX, JBUI.scale((int)100), heightLineX, DeviceDefinitionPreview.round(JBUI.scale((int)100) + screenSize.height));
            g2d.setColor(JBColor.background());
            int heightTextY = DeviceDefinitionPreview.round(JBUI.scale((int)100) + (screenSize.height + stringHeight) / 2);
            g2d.drawLine(heightLineX, heightTextY + FIGURE_PADDING, heightLineX, heightTextY - stringHeight - FIGURE_PADDING);
            g2d.setColor(JBColor.foreground());
            g2d.drawString(heightString, heightLineX - JBUI.scale((int)10), heightTextY);
            g2d.setColor((Color)OUR_GRAY);
            String diagString = FORMAT.format(this.myDevice.getDefaultHardware().getScreen().getDiagonalLength());
            int diagTextX = DeviceDefinitionPreview.round(PADDING + (screenSize.width - metrics.stringWidth(diagString)) / 2);
            int diagTextY = DeviceDefinitionPreview.round(JBUI.scale((int)100) + (screenSize.height + stringHeight) / 2);
            double chin = this.myDevice.getChinSize();
            Line2D.Double diagLine = new Line2D.Double(PADDING, (double)(JBUI.scale((int)100) + screenSize.height) + (chin *= screenSize.getWidth() / this.myDevice.getScreenSize(this.myDevice.getDefaultState().getOrientation()).getWidth()), PADDING + screenSize.width, JBUI.scale((int)100));
            if (isCircular) {
                double dist = 0.5 * ((double)screenSize.width - (double)screenSize.width / Math.sqrt(2.0));
                ((Line2D)diagLine).setLine(((Line2D)diagLine).getX1() + dist, ((Line2D)diagLine).getY1() - dist, ((Line2D)diagLine).getX2() - dist, ((Line2D)diagLine).getY2() + dist);
            }
            g2d.draw(diagLine);
            g2d.setColor(JBColor.background());
            Rectangle erasureRect = new Rectangle(diagTextX - FIGURE_PADDING, diagTextY - stringHeight - FIGURE_PADDING, metrics.stringWidth(diagString) + FIGURE_PADDING * 2, stringHeight + FIGURE_PADDING * 2);
            g2d.fill(erasureRect);
            g2d.setColor(JBColor.foreground());
            g2d.drawString(diagString, diagTextX, diagTextY);
            g2d.setStroke(new BasicStroke(OUTLINE_LINE_WIDTH));
            g2d.setColor(JBColor.foreground());
            if (isCircular) {
                double x = ((RectangularShape)roundRect).getX();
                double y = ((RectangularShape)roundRect).getY();
                Ellipse2D.Double circle = new Ellipse2D.Double(x, y, screenSize.width, (double)screenSize.height + chin);
                g2d.draw(circle);
                if (chin > 0.0) {
                    erasureRect = new Rectangle((int)x, (int)(y + (double)screenSize.height + (double)(OUTLINE_LINE_WIDTH / 2) + 1.0), screenSize.width, (int)chin + OUTLINE_LINE_WIDTH / 2 + 1);
                    g2d.setColor(JBColor.background());
                    g2d.fill(erasureRect);
                    g2d.setColor(JBColor.foreground());
                    double halfChinWidth = Math.sqrt(chin * ((double)screenSize.width - chin)) - (double)(OUTLINE_LINE_WIDTH / 2);
                    int chinX = (int)(x + (double)(screenSize.width / 2) - halfChinWidth);
                    g2d.drawLine(chinX, (int)(y + (double)screenSize.height), (int)((double)chinX + halfChinWidth * 2.0), (int)(y + (double)screenSize.height));
                }
            } else {
                g2d.draw(roundRect);
            }
            g2d.setFont(AvdWizardConstants.STANDARD_FONT);
            metrics = g2d.getFontMetrics(AvdWizardConstants.STANDARD_FONT);
            stringHeight = metrics.getHeight();
            if (this.myDevice.getDefaultState().getOrientation().equals((Object)ScreenOrientation.PORTRAIT)) {
                infoSegmentX = DeviceDefinitionPreview.round(PADDING + screenSize.width + metrics.stringWidth(heightString) + PADDING);
                infoSegmentY = JBUI.scale((int)100);
            } else {
                infoSegmentX = PADDING;
                infoSegmentY = DeviceDefinitionPreview.round(JBUI.scale((int)100) + screenSize.height + PADDING);
            }
            infoSegmentY += stringHeight;
            ScreenSize size = this.myDevice.getDefaultHardware().getScreen().getSize();
            if (size != null) {
                g2d.drawString("Size:      " + size.getResourceValue(), infoSegmentX, infoSegmentY);
                infoSegmentY += stringHeight;
            }
            if ((ratio = this.myDevice.getDefaultHardware().getScreen().getRatio()) != null) {
                g2d.drawString("Ratio:    " + ratio.getResourceValue(), infoSegmentX, infoSegmentY);
                infoSegmentY += stringHeight;
            }
            if ((pixelDensity = this.myDevice.getDefaultHardware().getScreen().getPixelDensity()) != null) {
                g2d.drawString("Density: " + pixelDensity.getResourceValue(), infoSegmentX, infoSegmentY);
            }
        }
    }

    private static int round(double d) {
        return (int)Math.round(d);
    }

    @Nullable
    private Dimension getScaledDimension(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/DeviceDefinitionPreview", "getScaledDimension"));
        }
        Dimension pixelSize = device.getScreenSize(device.getDefaultState().getOrientation());
        if (pixelSize == null) {
            return null;
        }
        double diagonalIn = device.getDefaultHardware().getScreen().getDiagonalLength();
        double sideRatio = pixelSize.getWidth() / pixelSize.getHeight();
        double heightIn = diagonalIn / Math.sqrt(1.0 + sideRatio);
        double widthIn = sideRatio * heightIn;
        double maxHeightIn = this.myMaxOutlineHeight == 0.0 ? heightIn : this.myMaxOutlineHeight;
        double maxWidthIn = this.myMaxOutlineWidth == 0.0 ? widthIn : this.myMaxOutlineWidth;
        double maxDimIn = Math.max(maxHeightIn, maxWidthIn);
        double desiredMaxWidthPx = this.getWidth() / 2;
        double desiredMaxHeightPx = this.getHeight() / 2;
        double desiredMaxPx = Math.min(desiredMaxHeightPx, desiredMaxWidthPx);
        double scalingFactorPxToIn = maxDimIn / desiredMaxPx;
        double desiredMinWidthPx = this.getWidth() / 10;
        double desiredMinHeightPx = this.getHeight() / 10;
        double desiredMinIn = Math.max(desiredMinWidthPx, desiredMinHeightPx) * scalingFactorPxToIn;
        double minDimIn = Math.min(this.myMinOutlineHeightIn, this.myMinOutlineWidthIn);
        if (minDimIn < desiredMinIn) {
            double f = (maxDimIn - desiredMinIn) / (maxDimIn - minDimIn);
            double c = (desiredMinIn * this.myMaxOutlineWidth - maxDimIn * minDimIn) / (maxDimIn - minDimIn);
            diagonalIn = device.getDefaultHardware().getScreen().getDiagonalLength();
            diagonalIn = diagonalIn * f + c;
            heightIn = diagonalIn / Math.sqrt(1.0 + sideRatio);
            widthIn = sideRatio * heightIn;
        }
        return new Dimension((int)(widthIn / scalingFactorPxToIn), (int)(heightIn / scalingFactorPxToIn));
    }

    @NotNull
    public static Icon getIcon(@Nullable Device device) {
        if (device == null) {
            Icon icon = AndroidIcons.FormFactors.Mobile_32;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceDefinitionPreview", "getIcon"));
            }
            return icon;
        }
        if (HardwareConfigHelper.isTv((Device)device)) {
            Icon icon = AndroidIcons.FormFactors.Tv_32;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceDefinitionPreview", "getIcon"));
            }
            return icon;
        }
        if (HardwareConfigHelper.isWear((Device)device)) {
            Icon icon = AndroidIcons.FormFactors.Wear_32;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceDefinitionPreview", "getIcon"));
            }
            return icon;
        }
        Icon icon = AndroidIcons.FormFactors.Mobile_32;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceDefinitionPreview", "getIcon"));
        }
        return icon;
    }

    @Override
    public void onCategorySelectionChanged(@Nullable String category, @Nullable List<Device> devices) {
        if (devices == null) {
            this.myMaxOutlineHeight = 0.0;
            this.myMaxOutlineWidth = 0.0;
            this.myMinOutlineHeightIn = 0.0;
            this.myMinOutlineWidthIn = 0.0;
        } else {
            double maxHeight = 0.0;
            double maxWidth = 0.0;
            double minHeight = Double.MAX_VALUE;
            double minWidth = Double.MAX_VALUE;
            for (Device d : devices) {
                Dimension pixelSize = d.getScreenSize(d.getDefaultState().getOrientation());
                if (pixelSize == null) continue;
                double diagonal = d.getDefaultHardware().getScreen().getDiagonalLength();
                double sideRatio = pixelSize.getWidth() / pixelSize.getHeight();
                double heightIn = diagonal / Math.sqrt(1.0 + sideRatio * sideRatio);
                double widthIn = sideRatio * heightIn;
                maxWidth = Math.max(maxWidth, widthIn);
                maxHeight = Math.max(maxHeight, heightIn);
                minWidth = Math.min(minWidth, widthIn);
                minHeight = Math.min(minHeight, heightIn);
            }
            this.myMaxOutlineHeight = maxHeight;
            this.myMaxOutlineWidth = maxWidth;
            this.myMinOutlineHeightIn = minHeight;
            this.myMinOutlineWidthIn = minWidth;
        }
    }
}

