/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFakeFileSystem
extends DummyFileSystem {
    @NonNls
    public static final String PROTOCOL = "android-dummy";
    public static final VirtualFileSystem INSTANCE = new AndroidFakeFileSystem();
    public static final char SEPARATOR = '/';

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/AndroidFakeFileSystem", "getProtocol"));
        }
        return PROTOCOL;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        Module m;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/editors/AndroidFakeFileSystem", "findFileByPath"));
        }
        List components = Splitter.on((char)'/').splitToList((CharSequence)path);
        int size = components.size();
        if (size < 3) {
            return null;
        }
        String projectPath = Joiner.on((char)'/').join(components.subList(0, size - 2));
        String moduleName = (String)components.get(size - 2);
        String fileName = (String)components.get(size - 1);
        Project project = AndroidFakeFileSystem.findProject(projectPath);
        if (project == null) {
            return null;
        }
        if ("Theme Editor".equals(fileName)) {
            if (moduleName.isEmpty()) {
                return ThemeEditorVirtualFile.getThemeEditorFile(project);
            }
        } else if ("Translations Editor".equals(fileName) && (m = AndroidFakeFileSystem.findModule(project, moduleName)) != null) {
            return StringsVirtualFile.getStringsVirtualFile(m);
        }
        return null;
    }

    @NotNull
    public static String constructPathForFile(@NotNull String fileName, @NotNull Module module) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/editors/AndroidFakeFileSystem", "constructPathForFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/AndroidFakeFileSystem", "constructPathForFile"));
        }
        String string = Joiner.on((char)'/').join((Object)module.getProject().getBasePath(), (Object)module.getName(), new Object[]{fileName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/AndroidFakeFileSystem", "constructPathForFile"));
        }
        return string;
    }

    @NotNull
    public static String constructPathForFile(@NotNull String fileName, @NotNull Project project) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/editors/AndroidFakeFileSystem", "constructPathForFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/AndroidFakeFileSystem", "constructPathForFile"));
        }
        String string = Joiner.on((char)'/').join((Object)project.getBasePath(), (Object)"", new Object[]{fileName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/AndroidFakeFileSystem", "constructPathForFile"));
        }
        return string;
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/AndroidFakeFileSystem", "findModule"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/AndroidFakeFileSystem", "findModule"));
        }
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    @Nullable
    private static Project findProject(@NotNull String basePath) {
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/android/tools/idea/editors/AndroidFakeFileSystem", "findProject"));
        }
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            if (!basePath.equals(p.getBasePath())) continue;
            return p;
        }
        return null;
    }
}

