/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.gapi;

import com.android.sdklib.repository.local.LocalExtraPkgInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.HashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public final class GapiPaths {
    private static final Map<String, String> ABI_REMAP = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("32-bit (arm)", "armeabi-v7a");
            this.put("64-bit (arm)", "arm64-v8a");
            this.put("armeabi", "armeabi-v7a");
        }
    });
    private static final Map<String, String> ARCH_REMAP = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("i386", "x86");
            this.put("amd64", "x86_64");
        }
    });
    private static final Map<String, String> ABI_TARGET = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("armeabi-v7a", "android-arm");
            this.put("arm64-v8a", "android-arm64");
        }
    });
    @NotNull
    private static final String HOST_OS;
    @NotNull
    private static final String HOST_ARCH;
    @NotNull
    private static final String GAPIS_EXECUTABLE_NAME;
    @NotNull
    private static final String GAPIR_EXECUTABLE_NAME;
    @NotNull
    private static final String GAPII_LIBRARY_NAME;
    @NotNull
    private static final String PKG_INFO_NAME = "pkginfo.apk";
    @NotNull
    private static final String EXE_EXTENSION;
    @NotNull
    private static final String SDK_VENDOR = "android";
    @NotNull
    private static final String SDK_PATH = "gapid";
    @NotNull
    private static final String OS_ANDROID = "android";
    @NotNull
    private static final Object myPathLock;
    private static File myBaseDir;
    private static File myGapisPath;
    private static File myGapirPath;
    private static File myPkgInfoPath;

    public static boolean isValid() {
        GapiPaths.findTools();
        return myGapisPath.exists();
    }

    @NotNull
    public static File base() {
        GapiPaths.findTools();
        File file = myBaseDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "base"));
        }
        return file;
    }

    @NotNull
    public static File gapis() {
        GapiPaths.findTools();
        File file = myGapisPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "gapis"));
        }
        return file;
    }

    @NotNull
    public static File gapir() {
        GapiPaths.findTools();
        File file = myGapirPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "gapir"));
        }
        return file;
    }

    @NotNull
    public static File findTraceLibrary(@NotNull String abi) throws IOException {
        if (abi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abi", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findTraceLibrary"));
        }
        GapiPaths.findTools();
        String remappedAbi = GapiPaths.remap(ABI_REMAP, abi);
        File lib = GapiPaths.findPath("android", remappedAbi, GAPII_LIBRARY_NAME);
        if (lib.exists()) {
            File file = lib;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findTraceLibrary"));
            }
            return file;
        }
        lib = GapiPaths.findPath("android", remappedAbi = GapiPaths.remap(ABI_TARGET, remappedAbi), GAPII_LIBRARY_NAME);
        if (lib.exists()) {
            File file = lib;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findTraceLibrary"));
            }
            return file;
        }
        throw new IOException("Unsupported " + GAPII_LIBRARY_NAME + " abi '" + abi + "'");
    }

    @NotNull
    public static File findPkgInfoApk() {
        GapiPaths.findTools();
        File file = myPkgInfoPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPkgInfoApk"));
        }
        return file;
    }

    @NotNull
    private static File findPath(@NotNull String os, String abi, @NotNull String binary) {
        File test;
        if (os == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "os", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPath"));
        }
        if (binary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binary", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPath"));
        }
        File osDir = new File(myBaseDir, os);
        if (abi != null) {
            test = new File(new File(osDir, abi), binary);
            if (test.exists()) {
                File file = test;
                if (file == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPath"));
                }
                return file;
            }
            test = new File(new File(myBaseDir, abi), binary);
            if (test.exists()) {
                File file = test;
                if (file == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPath"));
                }
                return file;
            }
        }
        if ((test = new File(osDir, binary)).exists()) {
            File file = test;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPath"));
            }
            return file;
        }
        File file = new File(myBaseDir, binary);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPath"));
        }
        return file;
    }

    private static String remap(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value == null) {
            value = key;
        }
        return value;
    }

    public static File getSdkPath() {
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdkData == null) {
            return null;
        }
        LocalExtraPkgInfo info = sdkData.getLocalSdk().getExtra("android", SDK_PATH);
        if (info == null) {
            return null;
        }
        return info.getLocalDir();
    }

    private static boolean checkForTools(File dir) {
        if (dir == null) {
            return false;
        }
        myBaseDir = dir;
        myGapisPath = GapiPaths.findPath(HOST_OS, HOST_ARCH, GAPIS_EXECUTABLE_NAME);
        myGapirPath = GapiPaths.findPath(HOST_OS, HOST_ARCH, GAPIR_EXECUTABLE_NAME);
        myPkgInfoPath = GapiPaths.findPath("android", null, PKG_INFO_NAME);
        return myGapisPath.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findTools() {
        Object object = myPathLock;
        synchronized (object) {
            String gopath;
            if (myGapisPath != null) {
                return;
            }
            if (Boolean.getBoolean("idea.is.internal") && (gopath = System.getenv("GOPATH")) != null && gopath.length() > 0 && GapiPaths.checkForTools(new File(gopath, "bin"))) {
                return;
            }
            if (GapiPaths.checkForTools(GapiPaths.getSdkPath())) {
                return;
            }
            GapiPaths.checkForTools(new File(new File(SystemProperties.getUserHome()), SDK_PATH));
        }
    }

    static {
        if (SystemInfo.isWindows) {
            HOST_OS = "windows";
            EXE_EXTENSION = ".exe";
        } else if (SystemInfo.isMac) {
            HOST_OS = "osx";
            EXE_EXTENSION = "";
        } else if (SystemInfo.isLinux) {
            HOST_OS = "linux";
            EXE_EXTENSION = "";
        } else {
            HOST_OS = SystemInfo.OS_NAME;
            EXE_EXTENSION = "";
        }
        HOST_ARCH = GapiPaths.remap(ARCH_REMAP, SystemInfo.OS_ARCH);
        GAPIS_EXECUTABLE_NAME = "gapis" + EXE_EXTENSION;
        GAPIR_EXECUTABLE_NAME = "gapir" + EXE_EXTENSION;
        GAPII_LIBRARY_NAME = "libgapii.so";
        myPathLock = new Object();
    }
}

