/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views.nodedata;

import com.android.tools.idea.editors.hprof.views.nodedata.HeapClassObjNode;
import com.android.tools.idea.editors.hprof.views.nodedata.HeapNode;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapPackageNode
implements HeapNode {
    @Nullable
    private HeapNode myParent;
    @NotNull
    private List<HeapNode> myChildren;
    @NotNull
    private HashMap<String, HeapPackageNode> mySubPackages;
    @NotNull
    private Set<HeapClassObjNode> myClasses;
    @NotNull
    private String myFullPackageName;
    @NotNull
    private String myPackageName;
    private int myTotalCount;
    private int myHeapInstanceCount;
    private int myShallowSize;
    private long myRetainedSize;

    public HeapPackageNode(@Nullable HeapPackageNode parent, @NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/editors/hprof/views/nodedata/HeapPackageNode", "<init>"));
        }
        this.myChildren = new ArrayList<HeapNode>();
        this.mySubPackages = new HashMap();
        this.myClasses = new HashSet();
        this.myPackageName = packageName;
        this.setParent(parent);
    }

    public void update(int currentHeapId) {
        this.myRetainedSize = 0L;
        for (HeapPackageNode heapPackageNode : this.mySubPackages.values()) {
            heapPackageNode.update(currentHeapId);
            this.updateCounts(heapPackageNode, currentHeapId);
        }
        for (HeapClassObjNode heapClassObjNode : this.myClasses) {
            this.updateCounts(heapClassObjNode, currentHeapId);
        }
    }

    private void updateCounts(@NotNull HeapNode heapNode, int currentHeapId) {
        if (heapNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heapNode", "com/android/tools/idea/editors/hprof/views/nodedata/HeapPackageNode", "updateCounts"));
        }
        this.myTotalCount += heapNode.getTotalCount();
        this.myHeapInstanceCount += heapNode.getHeapInstancesCount(currentHeapId);
        this.myShallowSize += heapNode.getShallowSize(currentHeapId);
        this.myRetainedSize += heapNode.getRetainedSize();
    }

    public void classifyClassObj(@NotNull HeapClassObjNode heapClassObjNode) {
        if (heapClassObjNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heapClassObjNode", "com/android/tools/idea/editors/hprof/views/nodedata/HeapPackageNode", "classifyClassObj"));
        }
        String className = heapClassObjNode.getClassObj().getClassName();
        assert (className.startsWith(this.myFullPackageName) && className.length() > this.myFullPackageName.length() + 1);
        String remainder = this.myFullPackageName.isEmpty() ? className : className.substring(this.myFullPackageName.length() + 1);
        int dotIndex = remainder.indexOf(46);
        if (dotIndex > 0) {
            assert (remainder.length() > 0);
            String subPackageName = remainder.substring(0, dotIndex);
            HeapPackageNode heapPackageNode = this.mySubPackages.get(subPackageName);
            if (heapPackageNode == null) {
                heapPackageNode = new HeapPackageNode(this, subPackageName);
                this.mySubPackages.put(subPackageName, heapPackageNode);
            }
            heapPackageNode.classifyClassObj(heapClassObjNode);
        } else {
            this.myClasses.add(heapClassObjNode);
        }
    }

    public void clear() {
        this.removeAllChildren();
        this.mySubPackages.clear();
        this.myClasses.clear();
        this.myTotalCount = 0;
        this.myHeapInstanceCount = 0;
        this.myShallowSize = 0;
        this.myRetainedSize = 0L;
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = this.myFullPackageName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/views/nodedata/HeapPackageNode", "getFullName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getSimpleName() {
        String string = this.myPackageName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/views/nodedata/HeapPackageNode", "getSimpleName"));
        }
        return string;
    }

    @Override
    public int getTotalCount() {
        return this.myTotalCount;
    }

    @Override
    public int getHeapInstancesCount(int heapId) {
        return this.myHeapInstanceCount;
    }

    @Override
    public int getInstanceSize() {
        return -1;
    }

    @Override
    public int getShallowSize(int heapId) {
        return this.myShallowSize;
    }

    @Override
    public long getRetainedSize() {
        return this.myRetainedSize;
    }

    @Override
    public void add(@NotNull HeapNode heapNode) {
        if (heapNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heapNode", "com/android/tools/idea/editors/hprof/views/nodedata/HeapPackageNode", "add"));
        }
        heapNode.removeFromParent();
        heapNode.setParent(this);
        this.myChildren.add(heapNode);
    }

    @Override
    @NotNull
    public List<HeapNode> getChildren() {
        List<HeapNode> list = this.myChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/views/nodedata/HeapPackageNode", "getChildren"));
        }
        return list;
    }

    @Override
    public void removeAllChildren() {
        for (HeapNode child : this.myChildren) {
            child.setParent(null);
        }
        this.myChildren.clear();
    }

    @NotNull
    public HashMap<String, HeapPackageNode> getSubPackages() {
        HashMap<String, HeapPackageNode> hashMap = this.mySubPackages;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/views/nodedata/HeapPackageNode", "getSubPackages"));
        }
        return hashMap;
    }

    public void buildTree() {
        for (HeapPackageNode heapPackageNode : this.mySubPackages.values()) {
            this.add(heapPackageNode);
            heapPackageNode.buildTree();
        }
        for (HeapClassObjNode heapClassObjNode : this.myClasses) {
            this.add(heapClassObjNode);
        }
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.myChildren.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.myChildren.size();
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode node) {
        assert (node instanceof HeapNode);
        return this.myChildren.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.myChildren.size() == 0;
    }

    public Enumeration children() {
        return Collections.enumeration(this.myChildren);
    }

    public void remove(@NotNull HeapNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/hprof/views/nodedata/HeapPackageNode", "remove"));
        }
        this.myChildren.remove(node);
    }

    @Override
    public void removeFromParent() {
        if (this.myParent != null) {
            assert (this.myParent instanceof HeapPackageNode);
            ((HeapPackageNode)this.myParent).remove(this);
            this.setParent(null);
        }
    }

    @Override
    public void setParent(@Nullable HeapNode newParent) {
        assert (newParent == null || newParent instanceof HeapPackageNode);
        this.myParent = newParent;
        this.myFullPackageName = this.myParent == null || this.myParent.getFullName().isEmpty() ? this.myPackageName : this.myParent.getFullName() + "." + this.myPackageName;
    }
}

