/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.MaterialColors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AccentSuggestionsUtils {
    private static final ImmutableMultimap<Color, Color> PRIMARY_ACCENT_MAP = ImmutableMultimap.builder().put((Object)MaterialColors.RED_500, (Object)MaterialColors.RED_ACCENT_100).put((Object)MaterialColors.RED_500, (Object)MaterialColors.RED_ACCENT_200).put((Object)MaterialColors.RED_500, (Object)MaterialColors.RED_ACCENT_400).put((Object)MaterialColors.RED_500, (Object)MaterialColors.RED_ACCENT_700).put((Object)MaterialColors.PINK_500, (Object)MaterialColors.PINK_ACCENT_100).put((Object)MaterialColors.PINK_500, (Object)MaterialColors.PINK_ACCENT_200).put((Object)MaterialColors.PINK_500, (Object)MaterialColors.PINK_ACCENT_400).put((Object)MaterialColors.PINK_500, (Object)MaterialColors.PINK_ACCENT_700).put((Object)MaterialColors.PURPLE_500, (Object)MaterialColors.PURPLE_ACCENT_100).put((Object)MaterialColors.PURPLE_500, (Object)MaterialColors.PURPLE_ACCENT_200).put((Object)MaterialColors.PURPLE_500, (Object)MaterialColors.PURPLE_ACCENT_400).put((Object)MaterialColors.PURPLE_500, (Object)MaterialColors.PURPLE_ACCENT_700).put((Object)MaterialColors.INDIGO_500, (Object)MaterialColors.INDIGO_ACCENT_100).put((Object)MaterialColors.INDIGO_500, (Object)MaterialColors.INDIGO_ACCENT_200).put((Object)MaterialColors.INDIGO_500, (Object)MaterialColors.INDIGO_ACCENT_400).put((Object)MaterialColors.INDIGO_500, (Object)MaterialColors.INDIGO_ACCENT_700).put((Object)MaterialColors.DEEP_PURPLE_500, (Object)MaterialColors.DEEP_PURPLE_ACCENT_100).put((Object)MaterialColors.DEEP_PURPLE_500, (Object)MaterialColors.DEEP_PURPLE_ACCENT_200).put((Object)MaterialColors.DEEP_PURPLE_500, (Object)MaterialColors.DEEP_PURPLE_ACCENT_400).put((Object)MaterialColors.DEEP_PURPLE_500, (Object)MaterialColors.DEEP_PURPLE_ACCENT_700).put((Object)MaterialColors.BLUE_500, (Object)MaterialColors.BLUE_ACCENT_100).put((Object)MaterialColors.BLUE_500, (Object)MaterialColors.BLUE_ACCENT_200).put((Object)MaterialColors.BLUE_500, (Object)MaterialColors.BLUE_ACCENT_400).put((Object)MaterialColors.BLUE_500, (Object)MaterialColors.BLUE_ACCENT_700).put((Object)MaterialColors.LIGHT_BLUE_500, (Object)MaterialColors.LIGHT_BLUE_ACCENT_100).put((Object)MaterialColors.LIGHT_BLUE_500, (Object)MaterialColors.LIGHT_BLUE_ACCENT_200).put((Object)MaterialColors.LIGHT_BLUE_500, (Object)MaterialColors.LIGHT_BLUE_ACCENT_400).put((Object)MaterialColors.LIGHT_BLUE_500, (Object)MaterialColors.LIGHT_BLUE_ACCENT_700).put((Object)MaterialColors.CYAN_500, (Object)MaterialColors.CYAN_ACCENT_100).put((Object)MaterialColors.CYAN_500, (Object)MaterialColors.CYAN_ACCENT_200).put((Object)MaterialColors.CYAN_500, (Object)MaterialColors.CYAN_ACCENT_400).put((Object)MaterialColors.CYAN_500, (Object)MaterialColors.CYAN_ACCENT_700).put((Object)MaterialColors.TEAL_500, (Object)MaterialColors.TEAL_ACCENT_100).put((Object)MaterialColors.TEAL_500, (Object)MaterialColors.TEAL_ACCENT_200).put((Object)MaterialColors.TEAL_500, (Object)MaterialColors.TEAL_ACCENT_400).put((Object)MaterialColors.TEAL_500, (Object)MaterialColors.TEAL_ACCENT_700).put((Object)MaterialColors.GREEN_500, (Object)MaterialColors.GREEN_ACCENT_100).put((Object)MaterialColors.GREEN_500, (Object)MaterialColors.GREEN_ACCENT_200).put((Object)MaterialColors.GREEN_500, (Object)MaterialColors.GREEN_ACCENT_400).put((Object)MaterialColors.GREEN_500, (Object)MaterialColors.GREEN_ACCENT_700).put((Object)MaterialColors.LIGHT_GREEN_500, (Object)MaterialColors.LIGHT_GREEN_ACCENT_100).put((Object)MaterialColors.LIGHT_GREEN_500, (Object)MaterialColors.LIGHT_GREEN_ACCENT_200).put((Object)MaterialColors.LIGHT_GREEN_500, (Object)MaterialColors.LIGHT_GREEN_ACCENT_400).put((Object)MaterialColors.LIGHT_GREEN_500, (Object)MaterialColors.LIGHT_GREEN_ACCENT_700).put((Object)MaterialColors.LIME_500, (Object)MaterialColors.LIME_ACCENT_100).put((Object)MaterialColors.LIME_500, (Object)MaterialColors.LIME_ACCENT_200).put((Object)MaterialColors.LIME_500, (Object)MaterialColors.LIME_ACCENT_400).put((Object)MaterialColors.LIME_500, (Object)MaterialColors.LIME_ACCENT_700).put((Object)MaterialColors.YELLOW_500, (Object)MaterialColors.YELLOW_ACCENT_100).put((Object)MaterialColors.YELLOW_500, (Object)MaterialColors.YELLOW_ACCENT_200).put((Object)MaterialColors.YELLOW_500, (Object)MaterialColors.YELLOW_ACCENT_400).put((Object)MaterialColors.YELLOW_500, (Object)MaterialColors.YELLOW_ACCENT_700).put((Object)MaterialColors.AMBER_500, (Object)MaterialColors.AMBER_ACCENT_100).put((Object)MaterialColors.AMBER_500, (Object)MaterialColors.AMBER_ACCENT_200).put((Object)MaterialColors.AMBER_500, (Object)MaterialColors.AMBER_ACCENT_400).put((Object)MaterialColors.AMBER_500, (Object)MaterialColors.AMBER_ACCENT_700).put((Object)MaterialColors.ORANGE_500, (Object)MaterialColors.ORANGE_ACCENT_100).put((Object)MaterialColors.ORANGE_500, (Object)MaterialColors.ORANGE_ACCENT_200).put((Object)MaterialColors.ORANGE_500, (Object)MaterialColors.ORANGE_ACCENT_400).put((Object)MaterialColors.ORANGE_500, (Object)MaterialColors.ORANGE_ACCENT_700).put((Object)MaterialColors.DEEP_ORANGE_500, (Object)MaterialColors.DEEP_ORANGE_ACCENT_100).put((Object)MaterialColors.DEEP_ORANGE_500, (Object)MaterialColors.DEEP_ORANGE_ACCENT_200).put((Object)MaterialColors.DEEP_ORANGE_500, (Object)MaterialColors.DEEP_ORANGE_ACCENT_400).put((Object)MaterialColors.DEEP_ORANGE_500, (Object)MaterialColors.DEEP_ORANGE_ACCENT_700).build();
    private static final ImmutableMap<Color, Integer> POSITION_MAP;
    private static final ImmutableList<Color> PRIMARY_COLOR_LIST;

    public static boolean isMaterialPrimary(@NotNull Color primaryColor) {
        if (primaryColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryColor", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "isMaterialPrimary"));
        }
        return POSITION_MAP.containsKey((Object)primaryColor);
    }

    @NotNull
    public static List<Color> getAssociatedAccents(@NotNull Color primaryColor) {
        if (primaryColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryColor", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "getAssociatedAccents"));
        }
        Integer position = (Integer)POSITION_MAP.get((Object)primaryColor);
        if (position != null) {
            int totalColors = PRIMARY_COLOR_LIST.size();
            ImmutableList immutableList = ImmutableList.builder().addAll((Iterable)PRIMARY_ACCENT_MAP.get(PRIMARY_COLOR_LIST.get((position + 1) % totalColors))).addAll((Iterable)PRIMARY_ACCENT_MAP.get(PRIMARY_COLOR_LIST.get((position - 1 + totalColors) % totalColors))).build();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "getAssociatedAccents"));
            }
            return immutableList;
        }
        List<Color> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "getAssociatedAccents"));
        }
        return list;
    }

    @NotNull
    public static List<Color> getMonochromaticAccents(@NotNull Color primaryColor) {
        if (primaryColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryColor", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "getMonochromaticAccents"));
        }
        Integer position = (Integer)POSITION_MAP.get((Object)primaryColor);
        if (position != null) {
            ImmutableList immutableList = PRIMARY_ACCENT_MAP.get(PRIMARY_COLOR_LIST.get(position.intValue())).asList();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "getMonochromaticAccents"));
            }
            return immutableList;
        }
        List<Color> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "getMonochromaticAccents"));
        }
        return list;
    }

    @NotNull
    public static List<Color> getComplementaryAccents(@NotNull Color primaryColor) {
        if (primaryColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryColor", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "getComplementaryAccents"));
        }
        Integer position = (Integer)POSITION_MAP.get((Object)primaryColor);
        if (position != null) {
            int totalColors = PRIMARY_COLOR_LIST.size();
            ImmutableList immutableList = PRIMARY_ACCENT_MAP.get(PRIMARY_COLOR_LIST.get((position + totalColors / 2) % totalColors)).asList();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "getComplementaryAccents"));
            }
            return immutableList;
        }
        List<Color> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "getComplementaryAccents"));
        }
        return list;
    }

    @NotNull
    public static List<Color> getTriadAccents(@NotNull Color primaryColor) {
        if (primaryColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryColor", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "getTriadAccents"));
        }
        Integer position = (Integer)POSITION_MAP.get((Object)primaryColor);
        if (position != null) {
            int totalColors = PRIMARY_COLOR_LIST.size();
            ImmutableList immutableList = ImmutableList.builder().addAll((Iterable)PRIMARY_ACCENT_MAP.get(PRIMARY_COLOR_LIST.get((position + totalColors / 2 + 1) % totalColors))).addAll((Iterable)PRIMARY_ACCENT_MAP.get(PRIMARY_COLOR_LIST.get((position + totalColors / 2 - 1) % totalColors))).build();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "getTriadAccents"));
            }
            return immutableList;
        }
        List<Color> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/AccentSuggestionsUtils", "getTriadAccents"));
        }
        return list;
    }

    static {
        int i = 0;
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Color primaryColor : PRIMARY_ACCENT_MAP.keySet()) {
            mapBuilder.put((Object)primaryColor, (Object)i++);
            listBuilder.add((Object)primaryColor);
        }
        POSITION_MAP = mapBuilder.build();
        PRIMARY_COLOR_LIST = listBuilder.build();
    }
}

