/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.preview;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.preview.ThemePreviewBuilder;
import com.android.tools.idea.editors.theme.preview.ToolbarComponentDefinition;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.android.tools.idea.rendering.multi.RenderPreviewManager;
import com.android.tools.swing.layoutlib.AndroidPreviewPanel;
import com.android.tools.swing.ui.NavigationComponent;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidThemePreviewPanel
extends Box
implements RenderContext,
Disposable {
    private static final Logger LOG = Logger.getInstance(AndroidThemePreviewPanel.class);
    private static final Map<String, ThemePreviewBuilder.ComponentDefinition> SUPPORT_LIBRARY_COMPONENTS = ImmutableMap.of((Object)"android.support.design.widget.FloatingActionButton", (Object)new ThemePreviewBuilder.ComponentDefinition("Fab", ThemePreviewBuilder.ComponentGroup.FAB_BUTTON, "android.support.design.widget.FloatingActionButton").set("src", "@drawable/abc_ic_ab_back_mtrl_am_alpha").set("layout_width", "56dp").set("layout_height", "56dp"), (Object)"android.support.v7.widget.Toolbar", (Object)new ToolbarComponentDefinition(true));
    private static final Map<String, String> SUPPORT_LIBRARY_REPLACEMENTS = ImmutableMap.of((Object)"android.support.v7.widget.Toolbar", (Object)"Toolbar");
    private static final boolean ENABLE_COMPONENTS_DRILL_DOWN = false;
    private static final String ERROR = "Error";
    private static final String PROGRESS = "Progress";
    private static final String PREVIEW = "Preview";
    private final JPanel myMainPanel;
    private Box myErrorPanel;
    private JTextPane myErrorLabel;
    private Box myProgressPanel;
    private AsyncProcessIcon myProgressIcon;
    private String mySearchTerm;
    private List<ThemePreviewBuilder.ComponentDefinition> myCustomComponents;
    private List<ThemePreviewBuilder.ComponentDefinition> mySupportLibraryComponents;
    private final List<String> myDisabledComponents;
    private final ThemeEditorContext myContext;
    protected final NavigationComponent<Breadcrumb> myBreadcrumbs;
    protected final AndroidPreviewPanel myAndroidPreviewPanel;
    protected final JBScrollPane myScrollPane;
    protected final DumbService myDumbService;
    private final Predicate<ThemePreviewBuilder.ComponentDefinition> myGroupFilter;
    private final Predicate<ThemePreviewBuilder.ComponentDefinition> mySupportReplacementsFilter;
    private float myScale;
    private boolean myIsAppCompatTheme;
    private boolean myShowError;

    public AndroidThemePreviewPanel(@NotNull ThemeEditorContext context, @NotNull Color background) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel", "<init>"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel", "<init>"));
        }
        super(3);
        this.mySearchTerm = "";
        this.myCustomComponents = Collections.emptyList();
        this.mySupportLibraryComponents = Collections.emptyList();
        this.myDisabledComponents = new ArrayList<String>();
        this.myGroupFilter = new Predicate<ThemePreviewBuilder.ComponentDefinition>(){

            public boolean apply(@Nullable ThemePreviewBuilder.ComponentDefinition input) {
                if (input == null) {
                    return false;
                }
                Breadcrumb breadcrumb = AndroidThemePreviewPanel.this.myBreadcrumbs.peek();
                return breadcrumb == null || breadcrumb.myGroup == null || breadcrumb.myGroup.equals((Object)input.group);
            }
        };
        this.mySupportReplacementsFilter = new Predicate<ThemePreviewBuilder.ComponentDefinition>(){

            public boolean apply(@Nullable ThemePreviewBuilder.ComponentDefinition input) {
                if (input == null) {
                    return false;
                }
                return !AndroidThemePreviewPanel.this.myDisabledComponents.contains(input.name);
            }
        };
        this.myScale = 1.0f;
        this.myIsAppCompatTheme = false;
        this.myShowError = false;
        this.setOpaque(true);
        this.setMinimumSize((Dimension)JBUI.size((int)200, (int)0));
        this.myContext = context;
        this.myContext.getProject().getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                AndroidThemePreviewPanel.this.updateMainPanel();
            }

            public void exitDumbMode() {
                AndroidThemePreviewPanel.this.updateMainPanel();
            }
        });
        this.myAndroidPreviewPanel = new AndroidPreviewPanel(this.myContext.getConfiguration());
        this.myContext.addChangeListener(new ThemeEditorContext.ChangeListener(){

            @Override
            public void onNewConfiguration(ThemeEditorContext context) {
                AndroidThemePreviewPanel.this.refreshConfiguration();
            }
        });
        this.myAndroidPreviewPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.myBreadcrumbs = new NavigationComponent();
        this.myBreadcrumbs.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myDumbService = DumbService.getInstance((Project)context.getProject());
        this.myScrollPane = new JBScrollPane((Component)this.myAndroidPreviewPanel, 20, 31);
        this.myScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.myScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.myScrollPane.setViewportBorder(null);
        this.myBreadcrumbs.setRootItem(new Breadcrumb("All components"));
        this.createErrorPanel();
        this.createProgressPanel();
        this.add(Box.createRigidArea((Dimension)JBUI.size((int)0, (int)5)));
        this.add(this.myBreadcrumbs);
        this.add(Box.createRigidArea((Dimension)JBUI.size((int)0, (int)10)));
        this.myMainPanel = new JPanel(new CardLayout());
        this.myMainPanel.add((Component)this.myErrorPanel, ERROR);
        this.myMainPanel.add((Component)this.myProgressPanel, PROGRESS);
        this.myMainPanel.add((Component)this.myScrollPane, PREVIEW);
        this.add(this.myMainPanel);
        this.setBackground(background);
        this.reloadComponents();
        this.myBreadcrumbs.addItemListener(new NavigationComponent.ItemListener<Breadcrumb>(){

            @Override
            public void itemSelected(@NotNull Breadcrumb item) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel$5", "itemSelected"));
                }
                AndroidThemePreviewPanel.this.myBreadcrumbs.goTo(item);
                AndroidThemePreviewPanel.this.rebuild();
            }
        });
        this.myContext.addConfigurationListener(new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                AndroidThemePreviewPanel.this.refreshConfiguration();
                if (ThemeEditorUtils.isSelectedAppCompatTheme(AndroidThemePreviewPanel.this.myContext) != AndroidThemePreviewPanel.this.myIsAppCompatTheme) {
                    AndroidThemePreviewPanel.this.rebuild();
                }
                return true;
            }
        });
        this.updateMainPanel();
    }

    private void updateMainPanel() {
        if (this.myDumbService.isDumb()) {
            this.myProgressIcon.resume();
            ((CardLayout)this.myMainPanel.getLayout()).show(this.myMainPanel, PROGRESS);
        } else {
            this.myProgressIcon.suspend();
            ((CardLayout)this.myMainPanel.getLayout()).show(this.myMainPanel, this.myShowError ? ERROR : PREVIEW);
        }
    }

    public void setSearchTerm(@NotNull String searchTerm) {
        if (searchTerm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchTerm", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel", "setSearchTerm"));
        }
        if (searchTerm.equals(this.mySearchTerm)) {
            return;
        }
        this.mySearchTerm = searchTerm;
        this.rebuild();
    }

    @Override
    public void setBackground(Color bg) {
        if (Objects.equal((Object)bg, (Object)this.getBackground())) {
            return;
        }
        super.setBackground(bg);
        this.myAndroidPreviewPanel.setBackground(bg);
        this.myScrollPane.getViewport().setBackground(bg);
        this.myBreadcrumbs.setBackground(bg);
        this.myMainPanel.setBackground(bg);
        this.rebuild();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.rebuild();
    }

    public void reloadComponents() {
        this.myDumbService.runWhenSmart(new Runnable(){

            @Override
            public void run() {
                Project project = AndroidThemePreviewPanel.this.myContext.getProject();
                if (!project.isOpen()) {
                    return;
                }
                PsiClass viewClass = JavaPsiFacade.getInstance((Project)project).findClass("android.view.View", GlobalSearchScope.allScope((Project)project));
                if (viewClass == null) {
                    LOG.error("Unable to find 'android.view.View'");
                    return;
                }
                Query viewClasses = ClassInheritorsSearch.search((PsiClass)viewClass, (SearchScope)ProjectScope.getProjectScope((Project)project), (boolean)true);
                final ArrayList customComponents = new ArrayList();
                viewClasses.forEach((Processor)new Processor<PsiClass>(){

                    public boolean process(PsiClass psiClass) {
                        String description = psiClass.getName();
                        String className = psiClass.getQualifiedName();
                        if (description == null || className == null) {
                            return false;
                        }
                        customComponents.add(new ThemePreviewBuilder.ComponentDefinition(description, ThemePreviewBuilder.ComponentGroup.CUSTOM, className));
                        return true;
                    }
                });
                AndroidThemePreviewPanel.this.myDisabledComponents.clear();
                final HashSet supportLibraryComponents = new HashSet();
                viewClasses = ClassInheritorsSearch.search((PsiClass)viewClass, (SearchScope)ProjectScope.getLibrariesScope((Project)project), (boolean)true);
                viewClasses.forEach((Processor)new Processor<PsiClass>(){

                    public boolean process(PsiClass psiClass) {
                        String className = psiClass.getQualifiedName();
                        ThemePreviewBuilder.ComponentDefinition component = (ThemePreviewBuilder.ComponentDefinition)SUPPORT_LIBRARY_COMPONENTS.get(className);
                        if (component != null) {
                            supportLibraryComponents.add(component);
                            String replaces = (String)SUPPORT_LIBRARY_REPLACEMENTS.get(className);
                            if (replaces != null) {
                                AndroidThemePreviewPanel.this.myDisabledComponents.add(replaces);
                            }
                        }
                        return true;
                    }
                });
                AndroidThemePreviewPanel.this.myCustomComponents = Collections.unmodifiableList(customComponents);
                AndroidThemePreviewPanel.this.mySupportLibraryComponents = (List)ImmutableList.copyOf(supportLibraryComponents);
                if (!AndroidThemePreviewPanel.this.myCustomComponents.isEmpty() || !AndroidThemePreviewPanel.this.mySupportLibraryComponents.isEmpty()) {
                    AndroidThemePreviewPanel.this.rebuild();
                }
            }
        });
        this.rebuild(false);
    }

    private void rebuild(boolean forceRepaint) {
        try {
            Configuration configuration = this.myContext.getConfiguration();
            int minApiLevel = configuration.getTarget() != null ? configuration.getTarget().getVersion().getApiLevel() : Integer.MAX_VALUE;
            ThemePreviewBuilder builder = new ThemePreviewBuilder().setBackgroundColor(this.getBackground()).addAllComponents(ThemePreviewBuilder.AVAILABLE_BASE_COMPONENTS).addAllComponents(this.myCustomComponents).addComponentFilter(new ThemePreviewBuilder.SearchFilter(this.mySearchTerm)).addComponentFilter(new ThemePreviewBuilder.ApiLevelFilter(minApiLevel)).addComponentFilter(this.myGroupFilter);
            this.myIsAppCompatTheme = ThemeEditorUtils.isSelectedAppCompatTheme(this.myContext);
            if (this.myIsAppCompatTheme) {
                builder.addComponentFilter(this.mySupportReplacementsFilter).addAllComponents(this.mySupportLibraryComponents);
            }
            this.myAndroidPreviewPanel.setDocument(builder.build());
            if (forceRepaint) {
                this.repaint();
            }
        }
        catch (ParserConfigurationException e) {
            LOG.error("Unable to generate dynamic theme preview", (Throwable)e);
        }
    }

    private void rebuild() {
        this.rebuild(true);
    }

    private void refreshConfiguration() {
        Configuration configuration = this.myContext.getConfiguration();
        this.myAndroidPreviewPanel.updateConfiguration(configuration);
        if (configuration.getDeviceState() != null) {
            float reverseDeviceScale = 160.0f / (float)configuration.getDeviceState().getHardware().getScreen().getPixelDensity().getDpiValue();
            this.myAndroidPreviewPanel.setScale(JBUI.scale((float)(reverseDeviceScale * this.myScale)));
        } else {
            LOG.error("Configuration getDeviceState returned null. Unable to set preview scale.");
        }
    }

    private void createProgressPanel() {
        this.myProgressIcon = new AsyncProcessIcon("Indexing");
        Disposer.register((Disposable)this, (Disposable)this.myProgressIcon);
        JLabel progressMessage = new JLabel("Waiting for indexing...");
        JPanel progressBlock = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        progressBlock.add((Component)this.myProgressIcon);
        progressBlock.add(progressMessage);
        progressBlock.setOpaque(false);
        this.myProgressPanel = new Box(3);
        this.myProgressPanel.add(Box.createVerticalGlue());
        this.myProgressPanel.add(progressBlock);
        this.myProgressPanel.add(Box.createVerticalGlue());
        this.myProgressPanel.setOpaque(false);
    }

    private void createErrorPanel() {
        this.myErrorLabel = new JTextPane(){

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        this.myErrorLabel.setOpaque(false);
        this.myErrorPanel = new Box(3);
        this.myErrorPanel.add(Box.createVerticalGlue());
        this.myErrorPanel.add(this.myErrorLabel);
        this.myErrorPanel.add(Box.createVerticalGlue());
        this.myErrorPanel.setOpaque(false);
        StyledDocument document = this.myErrorLabel.getStyledDocument();
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setAlignment(attributes, 1);
        document.setParagraphAttributes(0, document.getLength(), attributes, false);
    }

    public void setError(@Nullable String themeName) {
        boolean bl = this.myShowError = themeName != null;
        if (themeName != null) {
            this.myErrorLabel.setText("The theme " + themeName + " cannot be rendered in the current configuration");
        }
        this.updateMainPanel();
    }

    public void setScale(float scale) {
        this.myScale = scale;
    }

    public void invalidateGraphicsRenderer() {
        this.myAndroidPreviewPanel.invalidateGraphicsRenderer();
    }

    public void dispose() {
    }

    @Override
    @Nullable
    public Configuration getConfiguration() {
        return this.myContext.getConfiguration();
    }

    @Override
    public void setConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel", "setConfiguration"));
        }
        throw new UnsupportedOperationException("Configuration can not be changed on AndroidThemePreviewPanel");
    }

    @Override
    public void requestRender() {
    }

    @Override
    @NotNull
    public RenderContext.UsageType getType() {
        RenderContext.UsageType usageType = RenderContext.UsageType.UNKNOWN;
        if (usageType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel", "getType"));
        }
        return usageType;
    }

    @Override
    @Nullable
    public XmlFile getXmlFile() {
        return null;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Override
    @Nullable
    public Module getModule() {
        return null;
    }

    @Override
    public boolean hasAlphaChannel() {
        return false;
    }

    @Override
    @NotNull
    public Component getComponent() {
        AndroidThemePreviewPanel androidThemePreviewPanel = this;
        if (androidThemePreviewPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel", "getComponent"));
        }
        return androidThemePreviewPanel;
    }

    @Override
    @NotNull
    public Dimension getFullImageSize() {
        Dimension dimension = NO_SIZE;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel", "getFullImageSize"));
        }
        return dimension;
    }

    @Override
    @NotNull
    public Dimension getScaledImageSize() {
        Dimension dimension = NO_SIZE;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel", "getScaledImageSize"));
        }
        return dimension;
    }

    @Override
    @NotNull
    public Rectangle getClientArea() {
        Rectangle rectangle = new Rectangle();
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel", "getClientArea"));
        }
        return rectangle;
    }

    @Override
    public boolean supportsPreviews() {
        return false;
    }

    @Override
    @Nullable
    public RenderPreviewManager getPreviewManager(boolean createIfNecessary) {
        return null;
    }

    @Override
    public void setMaxSize(int width, int height) {
    }

    @Override
    public void zoomFit(boolean onlyZoomOut, boolean allowZoomIn) {
    }

    @Override
    public void updateLayout() {
    }

    @Override
    public void setDeviceFramesEnabled(boolean on) {
    }

    @Override
    @Nullable
    public BufferedImage getRenderedImage() {
        return null;
    }

    @Override
    @Nullable
    public RenderResult getLastResult() {
        return null;
    }

    @Override
    @Nullable
    public RenderedViewHierarchy getViewHierarchy() {
        return null;
    }

    static class Breadcrumb
    extends NavigationComponent.Item {
        private final ThemePreviewBuilder.ComponentGroup myGroup;
        private final String myDisplayText;

        private Breadcrumb(@NotNull String name, @Nullable ThemePreviewBuilder.ComponentGroup group) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel$Breadcrumb", "<init>"));
            }
            this.myDisplayText = name;
            this.myGroup = group;
        }

        public Breadcrumb(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel$Breadcrumb", "<init>"));
            }
            this(name, null);
        }

        public Breadcrumb(@NotNull ThemePreviewBuilder.ComponentGroup group) {
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel$Breadcrumb", "<init>"));
            }
            this(group.name, group);
        }

        @Override
        @NotNull
        public String getDisplayText() {
            String string = this.myDisplayText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/AndroidThemePreviewPanel$Breadcrumb", "getDisplayText"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Breadcrumb that = (Breadcrumb)o;
            return Objects.equal((Object)((Object)this.myGroup), (Object)((Object)that.myGroup)) && Objects.equal((Object)this.myDisplayText, (Object)that.myDisplayText);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myGroup, this.myDisplayText});
        }
    }
}

