/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteralMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public final class GradleDslLiteral
extends GradleDslElement {
    @Nullable
    private GrLiteral myLiteral;
    @Nullable
    private Object myUnsavedValue;

    public GradleDslLiteral(@NotNull GradleDslElement parent, @NotNull String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteral", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteral", "<init>"));
        }
        super(parent, null, name);
    }

    public GradleDslLiteral(@NotNull GradleDslElement parent, @NotNull GroovyPsiElement psiElement, @NotNull String name, @NotNull GrLiteral literal) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteral", "<init>"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteral", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteral", "<init>"));
        }
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteral", "<init>"));
        }
        super(parent, psiElement, name);
        this.myLiteral = literal;
    }

    @Nullable
    GrLiteral getLiteral() {
        return this.myLiteral;
    }

    @Nullable
    public Object getValue() {
        if (this.myUnsavedValue != null) {
            return this.myUnsavedValue;
        }
        if (this.myLiteral != null) {
            return this.myLiteral.getValue();
        }
        return null;
    }

    @Nullable
    public <T> T getValue(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteral", "getValue"));
        }
        Object value = this.getValue();
        if (value != null && clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }

    public void setValue(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteral", "setValue"));
        }
        this.myUnsavedValue = value;
        this.setModified(true);
    }

    public String toString() {
        Object value = this.getValue();
        return value != null ? value.toString() : super.toString();
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteral", "getChildren"));
        }
        return immutableList;
    }

    @Override
    @Nullable
    public GroovyPsiElement create() {
        GrNamedArgument addedNameArgument;
        GrLiteral literal;
        if (!(this.myParent instanceof GradleDslLiteralMap)) {
            return super.create();
        }
        GroovyPsiElement parentPsiElement = this.myParent.create();
        if (parentPsiElement == null) {
            return null;
        }
        this.setPsiElement(parentPsiElement);
        GrLiteral newLiteral = this.createLiteral();
        if (newLiteral == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)newLiteral.getProject());
        GrNamedArgument namedArgument = factory.createNamedArgument(this.myName, (GrExpression)newLiteral);
        PsiElement added = parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        if (added instanceof GrNamedArgument && (literal = (GrLiteral)PsiTreeUtil.getChildOfType((PsiElement)(addedNameArgument = (GrNamedArgument)added), GrLiteral.class)) != null) {
            this.myLiteral = literal;
            this.setModified(false);
            return this.getPsiElement();
        }
        return null;
    }

    @Override
    protected void delete() {
        if (this.myLiteral == null) {
            return;
        }
        PsiElement parent = this.myLiteral.getParent();
        this.myLiteral.delete();
        if (parent instanceof GrAssignmentExpression) {
            parent.delete();
        }
        if (parent instanceof GrCommandArgumentList) {
            GradleDslLiteral.deleteIfEmpty((GrCommandArgumentList)parent);
        } else if (parent instanceof GrListOrMap) {
            GradleDslLiteral.deleteIfEmpty((GrListOrMap)parent);
        }
    }

    private static void deleteIfEmpty(@NotNull GrCommandArgumentList commandArgumentList) {
        if (commandArgumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandArgumentList", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteral", "deleteIfEmpty"));
        }
        if (commandArgumentList.getAllArguments().length > 0) {
            return;
        }
        PsiElement parent = commandArgumentList.getParent();
        commandArgumentList.delete();
        if (parent instanceof GrApplicationStatement) {
            parent.delete();
        }
    }

    private static void deleteIfEmpty(@NotNull GrListOrMap listOrMap) {
        if (listOrMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOrMap", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslLiteral", "deleteIfEmpty"));
        }
        if (listOrMap.isMap() && listOrMap.getNamedArguments().length > 0 || !listOrMap.isMap() && listOrMap.getInitializers().length > 0) {
            return;
        }
        PsiElement parent = listOrMap.getParent();
        listOrMap.delete();
        if (parent instanceof GrAssignmentExpression) {
            parent.delete();
        }
    }

    @Override
    protected void apply() {
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GrLiteral newLiteral = this.createLiteral();
        if (newLiteral == null) {
            return;
        }
        if (this.myLiteral != null) {
            PsiElement replace = this.myLiteral.replace((PsiElement)newLiteral);
            if (replace instanceof GrLiteral) {
                this.myLiteral = (GrLiteral)replace;
            }
        } else {
            PsiElement added = psiElement.addAfter((PsiElement)newLiteral, psiElement.getLastChild());
            if (added instanceof GrLiteral) {
                this.myLiteral = (GrLiteral)added;
            }
        }
    }

    @Override
    protected void reset() {
        this.myUnsavedValue = null;
    }

    @Nullable
    private GrLiteral createLiteral() {
        if (this.myUnsavedValue == null) {
            return null;
        }
        CharSequence unsavedValueText = null;
        if (this.myUnsavedValue instanceof String) {
            unsavedValueText = GrStringUtil.getLiteralTextByValue((String)((String)this.myUnsavedValue));
        } else if (this.myUnsavedValue instanceof Integer || this.myUnsavedValue instanceof Boolean) {
            unsavedValueText = this.myUnsavedValue.toString();
        }
        this.myUnsavedValue = null;
        if (unsavedValueText == null) {
            return null;
        }
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        Project project = psiElement.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        GrExpression newExpression = factory.createExpressionFromText(unsavedValueText);
        if (!(newExpression instanceof GrLiteral)) {
            return null;
        }
        return (GrLiteral)newExpression;
    }
}

