/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.DynamicResourceValueRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.MultiResourceRepository;
import com.android.tools.idea.rendering.ResourceFolderRegistry;
import com.android.tools.idea.rendering.ResourceFolderRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;

    private ModuleResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/ModuleResourceRepository", "<init>"));
        }
        if (delegates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegates", "com/android/tools/idea/rendering/ModuleResourceRepository", "<init>"));
        }
        super(facet.getModule().getName(), delegates);
        this.myFacet = facet;
    }

    @Nullable
    public static LocalResourceRepository getModuleResources(@NotNull Module module, boolean createIfNecessary) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/ModuleResourceRepository", "getModuleResources"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            return facet.getModuleResources(createIfNecessary);
        }
        return null;
    }

    @Contract(value="!null, true -> !null")
    @Nullable
    public static LocalResourceRepository getModuleResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/ModuleResourceRepository", "getModuleResources"));
        }
        return facet.getModuleResources(createIfNecessary);
    }

    @NotNull
    public static LocalResourceRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/ModuleResourceRepository", "create"));
        }
        boolean gradleProject = facet.requiresAndroidModel();
        if (!gradleProject) {
            VirtualFile primaryResourceDir = facet.getPrimaryResourceDir();
            if (primaryResourceDir == null) {
                EmptyRepository emptyRepository = new EmptyRepository();
                if (emptyRepository == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ModuleResourceRepository", "create"));
                }
                return emptyRepository;
            }
            ResourceFolderRepository resourceFolderRepository = ResourceFolderRegistry.get(facet, primaryResourceDir);
            if (resourceFolderRepository == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ModuleResourceRepository", "create"));
            }
            return resourceFolderRepository;
        }
        ResourceFolderManager folderManager = facet.getResourceFolderManager();
        List<VirtualFile> resourceDirectories = folderManager.getFolders();
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)resourceDirectories.size());
        for (VirtualFile resourceDirectory : resourceDirectories) {
            ResourceFolderRepository repository = ResourceFolderRegistry.get(facet, resourceDirectory);
            resources.add(repository);
        }
        DynamicResourceValueRepository dynamicResources = DynamicResourceValueRepository.create(facet);
        resources.add(dynamicResources);
        final ModuleResourceRepository repository = new ModuleResourceRepository(facet, (List<? extends LocalResourceRepository>)resources);
        folderManager.addListener(new ResourceFolderManager.ResourceFolderListener(){

            @Override
            public void resourceFoldersChanged(@NotNull AndroidFacet facet, @NotNull List<VirtualFile> folders, @NotNull Collection<VirtualFile> added, @NotNull Collection<VirtualFile> removed) {
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/ModuleResourceRepository$1", "resourceFoldersChanged"));
                }
                if (folders == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folders", "com/android/tools/idea/rendering/ModuleResourceRepository$1", "resourceFoldersChanged"));
                }
                if (added == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "added", "com/android/tools/idea/rendering/ModuleResourceRepository$1", "resourceFoldersChanged"));
                }
                if (removed == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removed", "com/android/tools/idea/rendering/ModuleResourceRepository$1", "resourceFoldersChanged"));
                }
                repository.updateRoots();
            }
        });
        ModuleResourceRepository moduleResourceRepository = repository;
        if (moduleResourceRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ModuleResourceRepository", "create"));
        }
        return moduleResourceRepository;
    }

    private void updateRoots() {
        this.updateRoots(this.myFacet.getResourceFolderManager().getFolders());
    }

    void updateRoots(List<VirtualFile> resourceDirectories) {
        List other = null;
        HashMap map = Maps.newHashMap();
        for (LocalResourceRepository repository : this.myChildren) {
            if (repository instanceof ResourceFolderRepository) {
                ResourceFolderRepository folderRepository = (ResourceFolderRepository)repository;
                VirtualFile resourceDir = folderRepository.getResourceDir();
                map.put(resourceDir, folderRepository);
                continue;
            }
            assert (repository instanceof DynamicResourceValueRepository);
            if (other == null) {
                other = Lists.newArrayList();
            }
            other.add(repository);
        }
        HashSet newDirs = Sets.newHashSet(resourceDirectories);
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)(newDirs.size() + (other != null ? other.size() : 0)));
        for (VirtualFile dir : resourceDirectories) {
            ResourceFolderRepository repository = (ResourceFolderRepository)((Object)map.get(dir));
            if (repository == null) {
                repository = ResourceFolderRegistry.get(this.myFacet, dir);
            } else {
                map.remove(dir);
            }
            resources.add(repository);
        }
        if (other != null) {
            resources.addAll(other);
        }
        if (resources.equals(this.myChildren)) {
            assert (map.isEmpty());
            return;
        }
        for (ResourceFolderRepository removed : map.values()) {
            removed.removeParent(this);
        }
        this.setChildren(resources);
    }

    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull List<VirtualFile> resourceDirectories) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/ModuleResourceRepository", "createForTest"));
        }
        if (resourceDirectories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceDirectories", "com/android/tools/idea/rendering/ModuleResourceRepository", "createForTest"));
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)resourceDirectories.size());
        for (VirtualFile resourceDirectory : resourceDirectories) {
            ResourceFolderRepository repository = ResourceFolderRegistry.get(facet, resourceDirectory);
            resources.add(repository);
        }
        ModuleResourceRepository moduleResourceRepository = new ModuleResourceRepository(facet, (List<? extends LocalResourceRepository>)resources);
        if (moduleResourceRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ModuleResourceRepository", "createForTest"));
        }
        return moduleResourceRepository;
    }

    private static class EmptyRepository
    extends MultiResourceRepository {
        public EmptyRepository() {
            super("", Collections.emptyList());
        }

        @Override
        protected void setChildren(@NotNull List<? extends LocalResourceRepository> children) {
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/android/tools/idea/rendering/ModuleResourceRepository$EmptyRepository", "setChildren"));
            }
            this.myChildren = children;
        }
    }
}

