/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.rendering.multi.BinPacker;
import com.android.tools.idea.rendering.multi.RenderPreview;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PreviewBinPackingLayout {
    @NotNull
    private final List<RenderPreview> myPreviews;
    @NotNull
    private final RenderContext myRenderContext;
    private final int myX;
    private final int myY;
    private BinPacker myPacker;
    private int myLayoutHeight;

    public PreviewBinPackingLayout(@NotNull List<RenderPreview> previews, @NotNull RenderContext renderContext, int x, int y) {
        if (previews == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previews", "com/android/tools/idea/rendering/multi/PreviewBinPackingLayout", "<init>"));
        }
        if (renderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/android/tools/idea/rendering/multi/PreviewBinPackingLayout", "<init>"));
        }
        this.myPreviews = previews;
        this.myRenderContext = renderContext;
        this.myX = x;
        this.myY = y;
    }

    public boolean performLayout() {
        Rectangle clientArea = this.myRenderContext.getClientArea();
        Dimension scaledImageSize = this.myRenderContext.getScaledImageSize();
        int scaledImageWidth = scaledImageSize.width;
        int scaledImageHeight = scaledImageSize.height;
        int availableWidth = clientArea.x + clientArea.width - this.myX;
        int availableHeight = clientArea.y + clientArea.height - this.myY;
        int maxVisibleY = clientArea.y + clientArea.height;
        int bottomBorder = scaledImageHeight + 20;
        int rightHandSide = scaledImageWidth + 12 + 20;
        int minWidth = Integer.MAX_VALUE;
        int minHeight = Integer.MAX_VALUE;
        for (RenderPreview preview : this.myPreviews) {
            minWidth = Math.min(minWidth, preview.getLayoutWidth());
            minHeight = Math.min(minHeight, preview.getLayoutHeight());
        }
        BinPacker packer = new BinPacker(minWidth, minHeight);
        packer.addSpace(new Rectangle(rightHandSide, 0, availableWidth - rightHandSide + 12, availableHeight + 18));
        if (maxVisibleY > bottomBorder) {
            packer.addSpace(new Rectangle(0, bottomBorder + 18, availableWidth + 12, maxVisibleY - bottomBorder + 18));
        }
        ArrayList<RenderPreview> aspectOrder = new ArrayList<RenderPreview>(this.myPreviews);
        Collections.sort(aspectOrder, RenderPreview.INCREASING_ASPECT_RATIO);
        for (RenderPreview preview : aspectOrder) {
            Rectangle position;
            int previewWidth = preview.getLayoutWidth();
            int previewHeight = preview.getLayoutHeight();
            previewHeight += 18;
            if (preview.isForked()) {
                previewHeight += 18;
            }
            if ((position = packer.occupy(previewWidth += 12, previewHeight)) != null) {
                preview.setPosition(position.x, position.y);
                preview.setVisible(true);
                continue;
            }
            return false;
        }
        this.myLayoutHeight = availableHeight;
        return true;
    }

    public int getLayoutHeight() {
        return this.myLayoutHeight;
    }
}

