/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.PreciseRevision;
import com.android.tools.idea.sdk.remote.internal.archives.ArchFilter;
import com.android.tools.idea.sdk.remote.internal.archives.BitSize;
import com.android.tools.idea.sdk.remote.internal.archives.HostOs;
import com.android.tools.idea.sdk.remote.internal.archives.LegacyArch;
import com.android.tools.idea.sdk.remote.internal.archives.LegacyOs;
import java.util.Properties;
import org.w3c.dom.Node;

public class RemotePackageParserUtils {
    public static ArchFilter parseArchFilter(Node archiveNode) {
        LegacyArch a;
        String hos = RemotePackageParserUtils.getOptionalXmlString(archiveNode, "host-os");
        String hb = RemotePackageParserUtils.getOptionalXmlString(archiveNode, "host-bits");
        String jb = RemotePackageParserUtils.getOptionalXmlString(archiveNode, "jvm-bits");
        String mjv = RemotePackageParserUtils.getOptionalXmlString(archiveNode, "min-jvm-version");
        if (hos != null || hb != null || jb != null || mjv != null) {
            NoPreviewRevision rev = null;
            try {
                rev = NoPreviewRevision.parseRevision((String)mjv);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new ArchFilter(HostOs.fromXmlName(hos), BitSize.fromXmlName(hb), BitSize.fromXmlName(jb), rev);
        }
        Properties props = new Properties();
        LegacyOs o = (LegacyOs)((Object)RemotePackageParserUtils.getEnumAttribute(archiveNode, "os", (Object[])LegacyOs.values(), null));
        if (o != null) {
            props.setProperty("Archive.Os", o.toString());
        }
        if ((a = (LegacyArch)((Object)RemotePackageParserUtils.getEnumAttribute(archiveNode, "arch", (Object[])LegacyArch.values(), null))) != null) {
            props.setProperty("Archive.Arch", a.toString());
        }
        return new ArchFilter(props);
    }

    public static PreciseRevision parsePreciseRevisionElement(Node revisionNode) {
        if (revisionNode != null) {
            if (RemotePackageParserUtils.findChildElement(revisionNode, "major") != null) {
                int major = RemotePackageParserUtils.getXmlInt(revisionNode, "major", -1);
                int minor = RemotePackageParserUtils.getXmlInt(revisionNode, "minor", -1);
                if (minor == -1) {
                    return new PreciseRevision(major);
                }
                int micro = RemotePackageParserUtils.getXmlInt(revisionNode, "micro", -1);
                if (micro == -1) {
                    return new PreciseRevision(major, minor);
                }
                int preview = RemotePackageParserUtils.getXmlInt(revisionNode, "preview", -1);
                if (preview == -1) {
                    return new PreciseRevision(major, minor, micro);
                }
                return new PreciseRevision(major, minor, micro, preview);
            }
            try {
                String majorStr = revisionNode.getTextContent().trim();
                int major = Integer.parseInt(majorStr);
                return new PreciseRevision(major);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PreciseRevision(0);
    }

    public static Node findChildElement(Node node, String xmlLocalName) {
        if (node != null) {
            String nsUri = node.getNamespaceURI();
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1) continue;
                String nsUriChild = child.getNamespaceURI();
                if ((nsUri != null || nsUriChild != null) && (nsUri == null || !nsUri.equals(nsUriChild)) || xmlLocalName != null && !xmlLocalName.equals(child.getLocalName())) continue;
                return child;
            }
        }
        return null;
    }

    public static String getXmlString(Node node, String xmlLocalName) {
        return RemotePackageParserUtils.getXmlString(node, xmlLocalName, "");
    }

    public static String getXmlString(Node node, String xmlLocalName, String defaultValue) {
        Node child = RemotePackageParserUtils.findChildElement(node, xmlLocalName);
        String content = child == null ? null : child.getTextContent();
        return content == null || content.isEmpty() ? defaultValue : content;
    }

    public static String getOptionalXmlString(Node node, String xmlLocalName) {
        Node child = RemotePackageParserUtils.findChildElement(node, xmlLocalName);
        return child == null ? null : child.getTextContent();
    }

    public static int getXmlInt(Node node, String xmlLocalName, int defaultValue) {
        String s = RemotePackageParserUtils.getXmlString(node, xmlLocalName);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getXmlLong(Node node, String xmlLocalName, long defaultValue) {
        String s = RemotePackageParserUtils.getXmlString(node, xmlLocalName);
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Object getEnumAttribute(Node archiveNode, String attrName, Object[] values, Object defaultValue) {
        Node attr = archiveNode.getAttributes().getNamedItem(attrName);
        if (attr != null) {
            String found = attr.getNodeValue();
            for (Object value : values) {
                if (!value.toString().equalsIgnoreCase(found)) continue;
                return value;
            }
        }
        return defaultValue;
    }
}

