/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.swing;

import com.android.tools.idea.ui.properties.core.BoolProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public final class EditableProperty
extends BoolProperty
implements PropertyChangeListener {
    private final JTextComponent myTextComponent;

    public EditableProperty(JTextComponent textComponent) {
        this.myTextComponent = textComponent;
        this.myTextComponent.addPropertyChangeListener("editable", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyInvalidated();
    }

    @Override
    @NotNull
    public Boolean get() {
        Boolean bl = this.myTextComponent.isEditable();
        if (bl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/EditableProperty", "get"));
        }
        return bl;
    }

    @Override
    protected void setDirectly(@NotNull Boolean value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/swing/EditableProperty", "setDirectly"));
        }
        this.myTextComponent.setEditable(value);
    }
}

