/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.actions;

import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import icons.AndroidDesignerIcons;
import org.jetbrains.annotations.NotNull;

public class ToggleRenderModeAction
extends ToggleAction {
    private final DesignerEditorPanel myDesigner;
    private static boolean ourRenderViewPort;

    public ToggleRenderModeAction(@NotNull DesignerEditorPanel designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/android/designer/model/layout/actions/ToggleRenderModeAction", "<init>"));
        }
        this.myDesigner = designer;
        Presentation presentation = this.getTemplatePresentation();
        String label = "Toggle Viewport Render Mode";
        presentation.setDescription(label);
        presentation.setText(label);
        ToggleRenderModeAction.updateIcon(presentation);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        ToggleRenderModeAction.updateIcon(e.getPresentation());
    }

    private static void updateIcon(Presentation presentation) {
        presentation.setIcon(ourRenderViewPort ? AndroidDesignerIcons.NormalRender : AndroidDesignerIcons.ViewportRender);
    }

    public boolean isSelected(AnActionEvent e) {
        return ourRenderViewPort;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        ourRenderViewPort = state;
        ToggleRenderModeAction.updateIcon(e.getPresentation());
        ((AndroidDesignerEditorPanel)this.myDesigner).requestRender();
    }

    public static boolean isRenderViewPort() {
        return ourRenderViewPort;
    }
}

