/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerConverter
extends ResolvingConverter<String> {
    public static final IntegerConverter INSTANCE = new IntegerConverter();

    @NotNull
    public Collection<? extends String> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/IntegerConverter", "getVariants"));
        }
        return list;
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null || AndroidResourceUtil.isIdDeclaration(s) || AndroidResourceUtil.isIdReference(s)) {
            return s;
        }
        try {
            Long l = Long.decode(s);
            if (l >= 0x100000000L || l <= -4294967295L) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }
}

