/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ui.ProjectJdksEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;

public class AndroidSdkComboBoxWithBrowseButton
extends ComboboxWithBrowseButton {
    public AndroidSdkComboBoxWithBrowseButton() {
        JComboBox sdkCombobox = this.getComboBox();
        sdkCombobox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof Sdk) {
                    Sdk sdk = (Sdk)value;
                    this.setText(sdk.getName());
                    this.setIcon(((SdkType)sdk.getSdkType()).getIcon());
                } else {
                    this.setText("<html><font color='red'>[none]</font></html>");
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectJdksEditor editor = new ProjectJdksEditor(null, ProjectManager.getInstance().getDefaultProject(), (Component)((Object)AndroidSdkComboBoxWithBrowseButton.this));
                if (editor.showAndGet()) {
                    Sdk selectedJdk = editor.getSelectedJdk();
                    AndroidSdkComboBoxWithBrowseButton.this.rebuildSdksListAndSelectSdk(selectedJdk);
                    if (selectedJdk == null || !AndroidSdkUtils.isAndroidSdk(selectedJdk)) {
                        Messages.showErrorDialog((Component)((Object)AndroidSdkComboBoxWithBrowseButton.this), (String)AndroidBundle.message("select.platform.error", new Object[0]), (String)CommonBundle.getErrorTitle());
                    }
                }
            }
        });
        this.getButton().setToolTipText(AndroidBundle.message("android.add.sdk.tooltip", new Object[0]));
    }

    public Sdk getSelectedSdk() {
        return (Sdk)this.getComboBox().getSelectedItem();
    }

    public void rebuildSdksListAndSelectSdk(Sdk selectedSdk) {
        List sdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)AndroidSdkType.getInstance());
        JComboBox sdksComboBox = this.getComboBox();
        sdksComboBox.setModel(new DefaultComboBoxModel<Object>(sdks.toArray()));
        if (selectedSdk != null) {
            for (Sdk candidateSdk : sdks) {
                if (candidateSdk == null || !candidateSdk.getName().equals(selectedSdk.getName())) continue;
                sdksComboBox.setSelectedItem(candidateSdk);
                return;
            }
        }
        sdksComboBox.setSelectedItem(null);
    }
}

