/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.DomExtension;
import org.apache.batik.dom.ExtensibleDOMImplementation;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.extension.svg.BatikHistogramNormalizationElement;
import org.apache.batik.extension.svg.BatikRegularPolygonElement;
import org.apache.batik.extension.svg.BatikStarElement;
import org.apache.batik.extension.svg.ColorSwitchElement;
import org.apache.batik.extension.svg.FlowDivElement;
import org.apache.batik.extension.svg.FlowLineElement;
import org.apache.batik.extension.svg.FlowParaElement;
import org.apache.batik.extension.svg.FlowRegionBreakElement;
import org.apache.batik.extension.svg.FlowRegionElement;
import org.apache.batik.extension.svg.FlowSpanElement;
import org.apache.batik.extension.svg.FlowTextElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BatikDomExtension
implements DomExtension,
BatikExtConstants {
    @Override
    public float getPriority() {
        return 1.0f;
    }

    @Override
    public String getAuthor() {
        return "Thomas DeWeese";
    }

    @Override
    public String getContactAddress() {
        return "deweese@apache.org";
    }

    @Override
    public String getURL() {
        return "http://xml.apache.org/batik";
    }

    @Override
    public String getDescription() {
        return "Example extension to standard SVG shape tags";
    }

    @Override
    public void registerTags(ExtensibleDOMImplementation extensibleDOMImplementation) {
        extensibleDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "regularPolygon", new BatikRegularPolygonElementFactory());
        extensibleDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "star", new BatikStarElementFactory());
        extensibleDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "histogramNormalization", new BatikHistogramNormalizationElementFactory());
        extensibleDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "colorSwitch", new ColorSwitchElementFactory());
        extensibleDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowText", new FlowTextElementFactory());
        extensibleDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowDiv", new FlowDivElementFactory());
        extensibleDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowPara", new FlowParaElementFactory());
        extensibleDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowRegionBreak", new FlowRegionBreakElementFactory());
        extensibleDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowRegion", new FlowRegionElementFactory());
        extensibleDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowLine", new FlowLineElementFactory());
        extensibleDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowSpan", new FlowSpanElementFactory());
    }

    protected static class FlowSpanElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new FlowSpanElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowLineElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new FlowLineElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowRegionElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new FlowRegionElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowRegionBreakElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new FlowRegionBreakElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowParaElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new FlowParaElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowDivElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new FlowDivElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowTextElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new FlowTextElement(string, (AbstractDocument)document);
        }
    }

    protected static class ColorSwitchElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new ColorSwitchElement(string, (AbstractDocument)document);
        }
    }

    protected static class BatikHistogramNormalizationElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new BatikHistogramNormalizationElement(string, (AbstractDocument)document);
        }
    }

    protected static class BatikStarElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new BatikStarElement(string, (AbstractDocument)document);
        }
    }

    protected static class BatikRegularPolygonElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String string, Document document) {
            return new BatikRegularPolygonElement(string, (AbstractDocument)document);
        }
    }
}

