/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.Log;

class ScreenLineManager {
    private final JEditBuffer buffer;
    private char[] screenLines;

    ScreenLineManager(JEditBuffer jEditBuffer) {
        this.buffer = jEditBuffer;
        if (!jEditBuffer.isLoading()) {
            this.reset();
        }
    }

    boolean isScreenLineCountValid(int n) {
        return this.screenLines[n] > '\u0000';
    }

    int getScreenLineCount(int n) {
        assert (this.isScreenLineCountValid(n));
        return this.screenLines[n];
    }

    void setScreenLineCount(int n, int n2) {
        assert (n2 > 0) : "New line count is bogus!";
        if (n2 > Short.MAX_VALUE) {
            n2 = Short.MAX_VALUE;
            Log.log(9, this, new Exception("Max screen line count hit!"));
        }
        if (Debug.SCREEN_LINES_DEBUG) {
            Log.log(1, this, new Exception("setScreenLineCount(" + n + ',' + n2 + ')'));
        }
        this.screenLines[n] = (char)n2;
    }

    void invalidateScreenLineCounts() {
        int n = this.buffer.getLineCount();
        for (int i = 0; i < n; ++i) {
            this.invalidateScreenLineCount(i);
        }
    }

    private void invalidateScreenLineCount(int n) {
        this.screenLines[n] = '\u0000';
    }

    void reset() {
        this.screenLines = new char[this.buffer.getLineCount()];
    }

    public void contentInserted(int n, int n2) {
        int n3 = n + n2;
        this.invalidateScreenLineCount(n);
        int n4 = this.buffer.getLineCount();
        if (n2 > 0) {
            if (this.screenLines.length <= n4) {
                char[] cArray = new char[n4 + 1 << 1];
                System.arraycopy(this.screenLines, 0, cArray, 0, this.screenLines.length);
                this.screenLines = cArray;
            }
            System.arraycopy(this.screenLines, n, this.screenLines, n3, n4 - n3);
            for (int i = 0; i < n2; ++i) {
                this.screenLines[n + i] = '\u0000';
            }
        }
    }

    public void contentRemoved(int n, int n2) {
        int n3 = n + n2;
        this.invalidateScreenLineCount(n);
        if (n2 > 0 && n3 != this.screenLines.length) {
            System.arraycopy(this.screenLines, n3 + 1, this.screenLines, n + 1, this.screenLines.length - n3 - 1);
        }
    }
}

