/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.array.ArrayEnsureCapacityNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=ArrayEnsureCapacityNode.class)
public final class ArrayEnsureCapacityNodeGen
extends ArrayEnsureCapacityNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode requiredCapacity_;
    @CompilerDirectives.CompilationFinal
    private Class<?> requiredCapacityType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayEnsureCapacityNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
        super(context, sourceSection);
        this.array_ = array;
        this.requiredCapacity_ = requiredCapacity;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeEnsureCapacity(DynamicObject arrayValue, int requiredCapacityValue) {
        return this.specialization_.execute1(arrayValue, requiredCapacityValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        return this.specialization_.executeBoolean(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ArrayEnsureCapacityNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
        return new ArrayEnsureCapacityNodeGen(context, sourceSection, array, requiredCapacity);
    }

    @GeneratedBy(methodName="ensureCapacityObject(DynamicObject, int)", value=ArrayEnsureCapacityNode.class)
    private static final class EnsureCapacityObjectNode_
    extends BaseNode_ {
        private final Class<?> requiredCapacityImplicitType;

        EnsureCapacityObjectNode_(ArrayEnsureCapacityNodeGen root, Object requiredCapacityValue) {
            super(root, 4);
            this.requiredCapacityImplicitType = RubyTypesGen.getImplicitIntegerClass(requiredCapacityValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.requiredCapacityImplicitType == ((EnsureCapacityObjectNode_)other).requiredCapacityImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeBoolean_(ex.getResult(), requiredCapacityValue);
            }
            try {
                if (this.requiredCapacityImplicitType == Integer.TYPE) {
                    requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
                } else {
                    Object requiredCapacityValue__ = this.executeRequiredCapacity_(frameValue);
                    requiredCapacityValue_ = RubyTypesGen.expectImplicitInteger(requiredCapacityValue__, this.requiredCapacityImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean_(arrayValue_, ex.getResult());
            }
            if (ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.ensureCapacityObject(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeBoolean_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (ArrayGuards.isObjectArray(arrayValue)) {
                return this.root.ensureCapacityObject(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(arrayValue, requiredCapacityValue);
        }

        @Override
        public boolean executeBoolean_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = RubyTypesGen.asImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType);
                if (ArrayGuards.isObjectArray(arrayValue_)) {
                    return this.root.ensureCapacityObject(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeBoolean_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayEnsureCapacityNodeGen root, Object requiredCapacityValue) {
            return new EnsureCapacityObjectNode_(root, requiredCapacityValue);
        }
    }

    @GeneratedBy(methodName="ensureCapacityDouble(DynamicObject, int)", value=ArrayEnsureCapacityNode.class)
    private static final class EnsureCapacityDoubleNode_
    extends BaseNode_ {
        private final Class<?> requiredCapacityImplicitType;

        EnsureCapacityDoubleNode_(ArrayEnsureCapacityNodeGen root, Object requiredCapacityValue) {
            super(root, 3);
            this.requiredCapacityImplicitType = RubyTypesGen.getImplicitIntegerClass(requiredCapacityValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.requiredCapacityImplicitType == ((EnsureCapacityDoubleNode_)other).requiredCapacityImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeBoolean_(ex.getResult(), requiredCapacityValue);
            }
            try {
                if (this.requiredCapacityImplicitType == Integer.TYPE) {
                    requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
                } else {
                    Object requiredCapacityValue__ = this.executeRequiredCapacity_(frameValue);
                    requiredCapacityValue_ = RubyTypesGen.expectImplicitInteger(requiredCapacityValue__, this.requiredCapacityImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean_(arrayValue_, ex.getResult());
            }
            if (ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.ensureCapacityDouble(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeBoolean_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (ArrayGuards.isDoubleArray(arrayValue)) {
                return this.root.ensureCapacityDouble(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(arrayValue, requiredCapacityValue);
        }

        @Override
        public boolean executeBoolean_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = RubyTypesGen.asImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType);
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.ensureCapacityDouble(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeBoolean_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayEnsureCapacityNodeGen root, Object requiredCapacityValue) {
            return new EnsureCapacityDoubleNode_(root, requiredCapacityValue);
        }
    }

    @GeneratedBy(methodName="ensureCapacityLong(DynamicObject, int)", value=ArrayEnsureCapacityNode.class)
    private static final class EnsureCapacityLongNode_
    extends BaseNode_ {
        private final Class<?> requiredCapacityImplicitType;

        EnsureCapacityLongNode_(ArrayEnsureCapacityNodeGen root, Object requiredCapacityValue) {
            super(root, 2);
            this.requiredCapacityImplicitType = RubyTypesGen.getImplicitIntegerClass(requiredCapacityValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.requiredCapacityImplicitType == ((EnsureCapacityLongNode_)other).requiredCapacityImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeBoolean_(ex.getResult(), requiredCapacityValue);
            }
            try {
                if (this.requiredCapacityImplicitType == Integer.TYPE) {
                    requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
                } else {
                    Object requiredCapacityValue__ = this.executeRequiredCapacity_(frameValue);
                    requiredCapacityValue_ = RubyTypesGen.expectImplicitInteger(requiredCapacityValue__, this.requiredCapacityImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean_(arrayValue_, ex.getResult());
            }
            if (ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.ensureCapacityLong(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeBoolean_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (ArrayGuards.isLongArray(arrayValue)) {
                return this.root.ensureCapacityLong(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(arrayValue, requiredCapacityValue);
        }

        @Override
        public boolean executeBoolean_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = RubyTypesGen.asImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType);
                if (ArrayGuards.isLongArray(arrayValue_)) {
                    return this.root.ensureCapacityLong(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeBoolean_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayEnsureCapacityNodeGen root, Object requiredCapacityValue) {
            return new EnsureCapacityLongNode_(root, requiredCapacityValue);
        }
    }

    @GeneratedBy(methodName="ensureCapacityInt(DynamicObject, int)", value=ArrayEnsureCapacityNode.class)
    private static final class EnsureCapacityIntNode_
    extends BaseNode_ {
        private final Class<?> requiredCapacityImplicitType;

        EnsureCapacityIntNode_(ArrayEnsureCapacityNodeGen root, Object requiredCapacityValue) {
            super(root, 1);
            this.requiredCapacityImplicitType = RubyTypesGen.getImplicitIntegerClass(requiredCapacityValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.requiredCapacityImplicitType == ((EnsureCapacityIntNode_)other).requiredCapacityImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeBoolean_(ex.getResult(), requiredCapacityValue);
            }
            try {
                if (this.requiredCapacityImplicitType == Integer.TYPE) {
                    requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
                } else {
                    Object requiredCapacityValue__ = this.executeRequiredCapacity_(frameValue);
                    requiredCapacityValue_ = RubyTypesGen.expectImplicitInteger(requiredCapacityValue__, this.requiredCapacityImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean_(arrayValue_, ex.getResult());
            }
            if (ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.ensureCapacityInt(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeBoolean_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (ArrayGuards.isIntArray(arrayValue)) {
                return this.root.ensureCapacityInt(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(arrayValue, requiredCapacityValue);
        }

        @Override
        public boolean executeBoolean_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = RubyTypesGen.asImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType);
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.ensureCapacityInt(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeBoolean_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayEnsureCapacityNodeGen root, Object requiredCapacityValue) {
            return new EnsureCapacityIntNode_(root, requiredCapacityValue);
        }
    }

    @GeneratedBy(value=ArrayEnsureCapacityNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayEnsureCapacityNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, requiredCapacityValue));
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object requiredCapacityValue_ = this.executeRequiredCapacity_(frameValue);
            return this.getNext().executeBoolean_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public boolean executeBoolean_(Object arrayValue, Object requiredCapacityValue) {
            return this.getNext().executeBoolean_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayEnsureCapacityNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayEnsureCapacityNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayEnsureCapacityNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public boolean executeBoolean_(Object arrayValue, Object requiredCapacityValue) {
            return (Boolean)this.uninitialized((Frame)null, arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayEnsureCapacityNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayEnsureCapacityNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayEnsureCapacityNodeGen root;

        BaseNode_(ArrayEnsureCapacityNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ArrayEnsureCapacityNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.requiredCapacity_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.executeBoolean_(arrayValue, requiredCapacityValue);
        }

        public abstract boolean executeBoolean_(Object var1, Object var2);

        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            return this.executeBoolean_(arrayValue, requiredCapacityValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object requiredCapacityValue_ = this.executeRequiredCapacity_(frameValue);
            return this.executeBoolean_(arrayValue_, requiredCapacityValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        public boolean executeBoolean(VirtualFrame frameValue) {
            return (Boolean)this.execute0(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return EnsureCapacityIntNode_.create(this.root, requiredCapacityValue);
                }
                if (ArrayGuards.isLongArray(arrayValue_)) {
                    return EnsureCapacityLongNode_.create(this.root, requiredCapacityValue);
                }
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return EnsureCapacityDoubleNode_.create(this.root, requiredCapacityValue);
                }
                if (ArrayGuards.isObjectArray(arrayValue_)) {
                    return EnsureCapacityObjectNode_.create(this.root, requiredCapacityValue);
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeRequiredCapacity_(Frame frameValue) {
            Object object;
            Class requiredCapacityType_ = this.root.requiredCapacityType_;
            if (requiredCapacityType_ == Integer.TYPE) {
                return this.root.requiredCapacity_.executeInteger((VirtualFrame)frameValue);
            }
            if (requiredCapacityType_ != null) return this.root.requiredCapacity_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.requiredCapacity_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.requiredCapacityType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.requiredCapacityType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.requiredCapacityType_ = _type;
            return object;
        }
    }
}

