/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.ThreadLocalObjectNode;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;

public class ReadThreadLocalGlobalVariableNode
extends RubyNode {
    @Node.Child
    private ThreadLocalObjectNode threadLocalVariablesObjectNode;
    @Node.Child
    private ReadHeadObjectFieldNode readNode;

    public ReadThreadLocalGlobalVariableNode(RubyContext context, SourceSection sourceSection, String name) {
        super(context, sourceSection);
        this.threadLocalVariablesObjectNode = new ThreadLocalObjectNode(context, sourceSection);
        this.readNode = ReadHeadObjectFieldNodeGen.create(name, this.nil());
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject threadLocalVariablesObject = this.threadLocalVariablesObjectNode.executeDynamicObject(frame);
        return this.readNode.execute(threadLocalVariablesObject);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        DynamicObject threadLocalVariablesObject = this.threadLocalVariablesObjectNode.executeDynamicObject(frame);
        if (this.readNode.getName().equals("$~") || this.readNode.getName().equals("$!") || this.readNode.execute(threadLocalVariablesObject) != this.nil()) {
            return this.create7BitString(StringOperations.encodeByteList("global-variable", (Encoding)UTF8Encoding.INSTANCE));
        }
        return this.nil();
    }
}

