/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.xtf.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.ViewableProperties;
import ch.interlis.iom_j.ViewableProperty;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfStartTransferEvent;
import ch.interlis.iom_j.xtf.impl.AbstractXtfWriterAlt;
import ch.interlis.iox.IoxException;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;

public class Xtf24WriterAlt
extends AbstractXtfWriterAlt {
    private static final String MODEL_ELE = "model";
    private static final String COMMENT_ELE = "comment";
    private static final String SENDER_ELE = "sender";
    private static final String MODELS_ELE = "models";
    private static final String DATASECTION_ELE = "datasection";
    private static final String TRANSFER_ELE = "transfer";
    private static final String HEADERSECTION_ELE = "headersection";
    private ViewableProperties mapping = null;
    private HashMap nameMapping = null;
    public static final String xsiNs = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String iliNs = "http://www.interlis.ch/xtf/2.4/INTERLIS";
    private static final String geomNs = "http://www.interlis.ch/geometry/1.0";

    public Xtf24WriterAlt(OutputStreamWriter buffer, ViewableProperties mapping1) throws IoxException {
        this.mapping = mapping1;
        this.nameMapping = mapping1.getXtf24nameMapping();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        try {
            this.xout = outputFactory.createXMLStreamWriter(new BufferedWriter(buffer));
            String encoding = Charset.forName(buffer.getEncoding()).name();
            this.xout.writeStartDocument(encoding, "1.0");
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    @Override
    public void writeStartTransfer(String sender, String comment, XtfModel[] models) throws IoxException {
        this.writeStartTransfer(sender, comment, models, null);
    }

    @Override
    public void writeStartTransfer(String sender, String comment, XtfModel[] models, XtfStartTransferEvent e) throws IoxException {
        try {
            this.xout.writeStartElement(iliNs, TRANSFER_ELE);
            this.xout.writeNamespace("ili", iliNs);
            this.xout.writeNamespace("geom", geomNs);
            this.xout.writeNamespace("xsi", xsiNs);
            if (models == null || models.length == 0) {
                throw new IoxException("no models given");
            }
            int i = 0;
            while (i < models.length) {
                String modelName = models[i].getName();
                this.xout.writeNamespace(modelName, this.getXmlNs(modelName));
                ++i;
            }
            this.newline();
            this.xout.writeStartElement(iliNs, HEADERSECTION_ELE);
            if (sender == null || sender.length() == 0) {
                sender = "IOX";
            }
            this.xout.writeStartElement(iliNs, MODELS_ELE);
            if (models == null || models.length == 0) {
                throw new IoxException("no models given");
            }
            i = 0;
            while (i < models.length) {
                XtfModel model = models[i];
                this.writeElementStringOptional(iliNs, MODEL_ELE, model.getName());
                ++i;
            }
            this.xout.writeEndElement();
            this.writeElementStringOptional(iliNs, SENDER_ELE, sender);
            this.writeElementStringOptional(iliNs, COMMENT_ELE, comment);
            this.xout.writeEndElement();
            this.newline();
            this.xout.writeStartElement(iliNs, DATASECTION_ELE);
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    @Override
    public void writeEndTransfer() throws IoxException {
        try {
            this.xout.writeEndElement();
            this.newline();
            this.xout.writeEndElement();
            this.xout.writeEndDocument();
            this.xout.flush();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
        this.xout = null;
    }

    @Override
    public void writeStartBasket(String type, String bid) throws IoxException {
        this.writeStartBasket(type, bid, 0, 0, null, null, null);
    }

    @Override
    public void writeStartBasket(String type, String bid, int consistency, int kind, String startstate, String endstate, String[] topicv) throws IoxException {
        try {
            this.xout.writeStartElement(this.getXmlNs(type), this.getXmlName(type));
            this.xout.writeAttribute(iliNs, "bid", this.makeOid(bid));
            this.writeAttributeStringOptional(iliNs, "kind", Xtf24WriterAlt.encodeBasketKind(kind));
            if (kind != 0) {
                if (kind == 1) {
                    this.xout.writeAttribute(iliNs, "startstate", startstate);
                }
                this.xout.writeAttribute(iliNs, "endstate", endstate);
            }
            this.writeAttributeStringOptional(iliNs, "consistency", Xtf24WriterAlt.encodeConsistency(consistency));
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    @Override
    public void writeEndBasket() throws IoxException {
        try {
            this.xout.writeEndElement();
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    @Override
    public void writeObject(IomObject obj) throws IoxException {
        try {
            String type = obj.getobjecttag();
            this.xout.writeStartElement(this.getXmlNs(type), this.getXmlName(type));
            this.writeAttributeStringOptional(iliNs, "tid", this.makeOid(obj.getobjectoid()));
            this.writeAttributeStringOptional(iliNs, "operation", Xtf24WriterAlt.encodeOperation(obj.getobjectoperation()));
            this.writeObjAttrs(obj);
            this.xout.writeEndElement();
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeObjAttrs(IomObject obj) throws IoxException {
        String tag = obj.getobjecttag();
        if (this.mapping != null && this.mapping.existsClass(tag)) {
            ViewableProperty[] attrv = this.mapping.getClassVProperties(tag);
            int i = 0;
            while (i < attrv.length) {
                this.writeObjAttr(obj, attrv[i]);
                ++i;
            }
        } else {
            if (!this.unkClsv.contains(tag)) {
                EhiLogger.logError("unknown class " + tag);
                this.unkClsv.add(tag);
            }
            int i = 0;
            while (i < obj.getattrcount()) {
                this.writeObjAttr(obj, new ViewableProperty(obj.getattrname(i)));
                ++i;
            }
        }
    }

    private void writeObjAttr(IomObject obj, ViewableProperty attr) throws IoxException {
        String xmlns_attr = this.getXmlNs(obj.getobjecttag());
        String baseAttrInClass = attr.getBaseDefInClass();
        if (baseAttrInClass != null) {
            xmlns_attr = this.getXmlNs(baseAttrInClass);
        }
        String iliAttrName = attr.getName();
        try {
            int valueCount = obj.getattrvaluecount(iliAttrName);
            if (valueCount > 0) {
                String val = obj.getattrprim(iliAttrName, 0);
                if (val == null) {
                    IomObject child = obj.getattrobj(iliAttrName, 0);
                    if (child != null) {
                        if (child.getobjecttag().equals("COORD")) {
                            this.xout.writeStartElement(xmlns_attr, iliAttrName);
                            this.writeCoord("point", child);
                            this.xout.writeEndElement();
                            if (valueCount > 1) {
                                throw new IoxException("max one COORD value allowed (" + iliAttrName + ")");
                            }
                        } else if (child.getobjecttag().equals("POLYLINE")) {
                            String xmlAttrName = iliAttrName;
                            if (iliAttrName.startsWith("_itf_geom_")) {
                                xmlAttrName = "_geometry";
                            }
                            this.xout.writeStartElement(xmlns_attr, xmlAttrName);
                            this.writePolyline(child, false);
                            this.xout.writeEndElement();
                            if (valueCount > 1) {
                                throw new IoxException("max one POLYLINE value allowed (" + iliAttrName + ")");
                            }
                        } else if (child.getobjecttag().equals("MULTISURFACE")) {
                            this.xout.writeStartElement(xmlns_attr, iliAttrName);
                            this.writeSurface(child);
                            this.xout.writeEndElement();
                            if (valueCount > 1) {
                                throw new IoxException("max one MULTISURFACE value allowed (" + iliAttrName + ")");
                            }
                        } else {
                            boolean isRef;
                            String aref = child.getobjectrefoid();
                            boolean bl = isRef = aref != null;
                            if (isRef) {
                                String orderpos = null;
                                if (child.getobjectreforderpos() > 0L) {
                                    orderpos = Long.toString(child.getobjectreforderpos());
                                }
                                this.xout.writeStartElement(xmlns_attr, iliAttrName);
                                this.xout.writeAttribute(iliNs, "ref", this.makeOid(aref));
                                this.writeAttributeStringOptional(iliNs, "order_pos", orderpos);
                                if (child.getattrcount() > 0) {
                                    String structType = child.getobjecttag();
                                    this.xout.writeStartElement(this.getXmlNs(structType), this.getXmlName(structType));
                                    this.writeObjAttrs(child);
                                    this.xout.writeEndElement();
                                }
                                this.xout.writeEndElement();
                                if (valueCount > 1) {
                                    throw new IoxException("max one reference value allowed (" + iliAttrName + ")");
                                }
                            } else {
                                this.xout.writeStartElement(xmlns_attr, iliAttrName);
                                int valuei = 0;
                                while (true) {
                                    String structType = child.getobjecttag();
                                    this.xout.writeStartElement(this.getXmlNs(structType), this.getXmlName(structType));
                                    this.writeObjAttrs(child);
                                    this.xout.writeEndElement();
                                    if (++valuei >= valueCount) break;
                                    child = obj.getattrobj(iliAttrName, valuei);
                                }
                                this.xout.writeEndElement();
                            }
                        }
                    }
                } else {
                    this.writeElementStringOptional(xmlns_attr, iliAttrName, val);
                    if (valueCount > 1) {
                        throw new IoxException("max one primitive-type value allowed (" + iliAttrName + ")");
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeCoord(String localName, IomObject obj) throws IoxException {
        try {
            this.xout.writeStartElement(geomNs, localName);
            String c1 = obj.getattrprim("C1", 0);
            this.writeElementStringOptional(geomNs, "c1", c1);
            String c2 = obj.getattrprim("C2", 0);
            if (c2 != null) {
                this.writeElementStringOptional(geomNs, "c2", c2);
                String c3 = obj.getattrprim("C3", 0);
                if (c3 != null) {
                    this.writeElementStringOptional(geomNs, "c3", c3);
                }
            }
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeArc(IomObject obj) throws IoxException {
        try {
            String r;
            this.xout.writeStartElement(geomNs, "arc");
            String a1 = obj.getattrprim("A1", 0);
            this.writeElementStringOptional(geomNs, "a1", a1);
            String a2 = obj.getattrprim("A2", 0);
            this.writeElementStringOptional(geomNs, "a2", a2);
            String c1 = obj.getattrprim("C1", 0);
            this.writeElementStringOptional(geomNs, "c1", c1);
            String c2 = obj.getattrprim("C2", 0);
            this.writeElementStringOptional(geomNs, "c2", c2);
            String c3 = obj.getattrprim("C3", 0);
            if (c3 != null) {
                this.writeElementStringOptional(geomNs, "c3", c3);
            }
            if ((r = obj.getattrprim("R", 0)) != null) {
                this.writeElementStringOptional(geomNs, "a", r);
            }
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writePolyline(IomObject obj, boolean noPolylineTag) throws IoxException {
        try {
            if (!noPolylineTag) {
                this.xout.writeStartElement(geomNs, "polyline");
            }
            boolean clipped = obj.getobjectconsistency() == 1;
            int sequencei = 0;
            while (sequencei < obj.getattrvaluecount("sequence")) {
                if (clipped) {
                    this.xout.writeStartElement(iliNs, "CLIPPED");
                } else if (sequencei > 0) {
                    throw new IllegalArgumentException("unclipped polyline with multi 'sequence' elements");
                }
                IomObject sequence = obj.getattrobj("sequence", sequencei);
                int segmenti = 0;
                while (segmenti < sequence.getattrvaluecount("segment")) {
                    IomObject segment = sequence.getattrobj("segment", segmenti);
                    if (segment.getobjecttag().equals("COORD")) {
                        this.writeCoord(segmenti == 0 ? "start" : "straight", segment);
                    } else if (segment.getobjecttag().equals("ARC")) {
                        this.writeArc(segment);
                    } else {
                        String structType = segment.getobjecttag();
                        this.xout.writeStartElement(this.getXmlNs(structType), this.getXmlName(structType));
                        this.writeObjAttrs(segment);
                        this.xout.writeEndElement();
                    }
                    ++segmenti;
                }
                if (clipped) {
                    this.xout.writeEndElement();
                }
                ++sequencei;
            }
            if (!noPolylineTag) {
                this.xout.writeEndElement();
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeSurface(IomObject obj) throws IoxException {
        try {
            this.xout.writeStartElement(geomNs, "surface");
            boolean clipped = obj.getobjectconsistency() == 1;
            int surfacei = 0;
            while (surfacei < obj.getattrvaluecount("surface")) {
                if (clipped) {
                    this.xout.writeStartElement(iliNs, "CLIPPED");
                } else if (surfacei > 0) {
                    throw new IllegalArgumentException("unclipped surface with multi 'surface' elements");
                }
                IomObject surface = obj.getattrobj("surface", surfacei);
                int boundaryi = 0;
                while (boundaryi < surface.getattrvaluecount("boundary")) {
                    IomObject boundary = surface.getattrobj("boundary", boundaryi);
                    this.xout.writeStartElement(geomNs, boundaryi == 0 ? "exterior" : "interior");
                    int polylinei = 0;
                    while (polylinei < boundary.getattrvaluecount("polyline")) {
                        IomObject polyline = boundary.getattrobj("polyline", polylinei);
                        IomObject lineattr = polyline.getattrobj("lineattr", 0);
                        if (lineattr != null) {
                            this.xout.writeStartElement(geomNs, "lineattr");
                            String structType = lineattr.getobjecttag();
                            this.writeObjAttrs(lineattr);
                            this.xout.writeEndElement();
                        }
                        this.writePolyline(polyline, true);
                        ++polylinei;
                    }
                    this.xout.writeEndElement();
                    ++boundaryi;
                }
                if (clipped) {
                    this.xout.writeEndElement();
                }
                ++surfacei;
            }
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeElementStringOptional(String ns, String name, String value) throws IoxException {
        try {
            String v;
            if (value != null && (v = value.trim()).length() > 0) {
                this.xout.writeStartElement(ns, name);
                this.xout.writeCharacters(v);
                this.xout.writeEndElement();
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeAttributeStringOptional(String ns, String name, String value) throws IoxException {
        try {
            String v;
            if (value != null && (v = value.trim()).length() > 0) {
                if (ns != null) {
                    this.xout.writeAttribute(ns, name, v);
                } else {
                    this.xout.writeAttribute(name, v);
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private static String encodeConsistency(int consistency) {
        String ret = null;
        switch (consistency) {
            case 1: {
                ret = "INCOMPLETE";
                break;
            }
            case 2: {
                ret = null;
                break;
            }
            case 3: {
                ret = null;
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    private static String encodeBasketKind(int kind) {
        String ret = null;
        switch (kind) {
            case 1: {
                ret = "UPDATE";
                break;
            }
            case 2: {
                ret = "INITIAL";
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    private static String encodeOperation(int ops) {
        String ret = null;
        switch (ops) {
            case 1: {
                ret = "UPDATE";
                break;
            }
            case 2: {
                ret = "DELETE";
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    private String getXmlNs(String type) {
        int pos = type.indexOf(46);
        String ret = "http://www.interlis.ch/xtf/2.4/" + (pos >= 0 ? type.substring(0, pos) : type);
        return ret;
    }

    private String getXmlName(String type) {
        if (!this.nameMapping.containsKey(type)) {
            throw new IllegalArgumentException(type);
        }
        String ret = (String)this.nameMapping.get(type);
        return ret;
    }

    private String makeOid(String value) {
        String v;
        if (value != null && (v = value.trim()).length() > 0) {
            return v;
        }
        return null;
    }
}

