/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.component;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;

public abstract class AbstractLifecycleComponent<T>
extends AbstractComponent
implements LifecycleComponent<T> {
    protected final Lifecycle lifecycle = new Lifecycle();
    private final List<LifecycleListener> listeners = new CopyOnWriteArrayList<LifecycleListener>();

    protected AbstractLifecycleComponent(Settings settings) {
        super(settings);
    }

    protected AbstractLifecycleComponent(Settings settings, Class customClass) {
        super(settings, customClass);
    }

    @Override
    public Lifecycle.State lifecycleState() {
        return this.lifecycle.state();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public T start() {
        if (!this.lifecycle.canMoveToStarted()) {
            return (T)this;
        }
        for (LifecycleListener listener : this.listeners) {
            listener.beforeStart();
        }
        this.doStart();
        this.lifecycle.moveToStarted();
        for (LifecycleListener listener : this.listeners) {
            listener.afterStart();
        }
        return (T)this;
    }

    protected abstract void doStart();

    @Override
    public T stop() {
        if (!this.lifecycle.canMoveToStopped()) {
            return (T)this;
        }
        for (LifecycleListener listener : this.listeners) {
            listener.beforeStop();
        }
        this.lifecycle.moveToStopped();
        this.doStop();
        for (LifecycleListener listener : this.listeners) {
            listener.afterStop();
        }
        return (T)this;
    }

    protected abstract void doStop();

    @Override
    public void close() {
        if (this.lifecycle.started()) {
            this.stop();
        }
        if (!this.lifecycle.canMoveToClosed()) {
            return;
        }
        for (LifecycleListener listener : this.listeners) {
            listener.beforeClose();
        }
        this.lifecycle.moveToClosed();
        this.doClose();
        for (LifecycleListener listener : this.listeners) {
            listener.afterClose();
        }
    }

    protected abstract void doClose();
}

