/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.ChannelReference;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogWriter;

public final class BufferingTranslogWriter
extends TranslogWriter {
    private byte[] buffer;
    private int bufferCount;
    private WrapperOutputStream bufferOs = new WrapperOutputStream();
    private volatile long totalOffset;

    public BufferingTranslogWriter(ShardId shardId, long generation, ChannelReference channelReference, int bufferSize) throws IOException {
        super(shardId, generation, channelReference);
        this.buffer = new byte[bufferSize];
        this.totalOffset = this.writtenOffset;
    }

    @Override
    public Translog.Location add(BytesReference data) throws IOException {
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            long offset = this.totalOffset;
            if (data.length() >= this.buffer.length) {
                this.flush();
                try {
                    data.writeTo(this.channel);
                }
                catch (Throwable ex) {
                    this.closeWithTragicEvent(ex);
                    throw ex;
                }
                this.writtenOffset += (long)data.length();
                this.totalOffset += (long)data.length();
            } else {
                if (data.length() > this.buffer.length - this.bufferCount) {
                    this.flush();
                }
                data.writeTo(this.bufferOs);
                this.totalOffset += (long)data.length();
            }
            ++this.operationCounter;
            Translog.Location location = new Translog.Location(this.generation, offset, data.length());
            return location;
        }
    }

    @Override
    protected final void flush() throws IOException {
        assert (this.writeLock.isHeldByCurrentThread().booleanValue());
        if (this.bufferCount > 0) {
            this.ensureOpen();
            int bufferSize = this.bufferCount;
            try {
                Channels.writeToChannel(this.buffer, 0, bufferSize, (WritableByteChannel)this.channel);
            }
            catch (Throwable ex) {
                this.closeWithTragicEvent(ex);
                throw ex;
            }
            this.writtenOffset += (long)bufferSize;
            this.bufferCount = 0;
        }
    }

    @Override
    protected void readBytes(ByteBuffer targetBuffer, long position) throws IOException {
        try (ReleasableLock lock = this.readLock.acquire();){
            if (position >= this.writtenOffset) {
                assert (targetBuffer.hasArray()) : "buffer must have array";
                int sourcePosition = (int)(position - this.writtenOffset);
                System.arraycopy(this.buffer, sourcePosition, targetBuffer.array(), targetBuffer.position(), targetBuffer.limit());
                targetBuffer.position(targetBuffer.limit());
                return;
            }
        }
        Channels.readFromFileChannelWithEofException(this.channel, position, targetBuffer);
    }

    @Override
    public boolean syncNeeded() {
        return this.totalOffset != this.lastSyncedOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sync() throws IOException {
        if (this.syncNeeded()) {
            this.ensureOpen();
            this.channelReference.incRef();
            try {
                int opsCounter;
                long offsetToSync;
                try (ReleasableLock lock = this.writeLock.acquire();){
                    this.flush();
                    offsetToSync = this.totalOffset;
                    opsCounter = this.operationCounter;
                }
                this.ensureOpen();
                this.checkpoint(offsetToSync, opsCounter, this.channelReference);
                this.lastSyncedOffset = offsetToSync;
            }
            finally {
                this.channelReference.decRef();
            }
        }
    }

    @Override
    public void updateBufferSize(int bufferSize) {
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            if (this.buffer.length != bufferSize) {
                this.flush();
                this.buffer = new byte[bufferSize];
            }
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to flush", e);
        }
    }

    @Override
    public long sizeInBytes() {
        return this.totalOffset;
    }

    class WrapperOutputStream
    extends OutputStream {
        WrapperOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ((BufferingTranslogWriter)BufferingTranslogWriter.this).buffer[((BufferingTranslogWriter)BufferingTranslogWriter.this).bufferCount++] = (byte)b;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            System.arraycopy(b, off, BufferingTranslogWriter.this.buffer, BufferingTranslogWriter.this.bufferCount, len);
            BufferingTranslogWriter.this.bufferCount = BufferingTranslogWriter.this.bufferCount + len;
        }
    }
}

