/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.profile.Profiler;

public final class Profilers {
    private final ContextIndexSearcher searcher;
    private final List<Profiler> profilers;

    public Profilers(ContextIndexSearcher searcher) {
        this.searcher = searcher;
        this.profilers = new ArrayList<Profiler>();
        this.addProfiler();
    }

    public Profiler addProfiler() {
        Profiler profiler = new Profiler();
        this.searcher.setProfiler(profiler);
        this.profilers.add(profiler);
        return profiler;
    }

    public Profiler getCurrent() {
        return this.profilers.get(this.profilers.size() - 1);
    }

    public List<Profiler> getProfilers() {
        return Collections.unmodifiableList(this.profilers);
    }
}

