/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.util.concurrent.Callable;
import org.gradle.cache.internal.FileAccess;
import org.gradle.cache.internal.btree.BlockPayload;
import org.gradle.cache.internal.btree.BlockPointer;
import org.gradle.cache.internal.btree.BlockStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockingBlockStore
implements BlockStore {
    private final BlockStore store;
    private final FileAccess fileAccess;

    public LockingBlockStore(BlockStore store, FileAccess fileAccess) {
        this.store = store;
        this.fileAccess = fileAccess;
    }

    @Override
    public void open(final Runnable initAction, BlockStore.Factory factory) {
        this.store.open(new Runnable(){

            public void run() {
                LockingBlockStore.this.fileAccess.updateFile(initAction);
            }
        }, factory);
    }

    @Override
    public void close() {
        this.store.close();
    }

    @Override
    public void flush() {
        this.fileAccess.updateFile(new Runnable(){

            public void run() {
                LockingBlockStore.this.store.flush();
            }
        });
    }

    @Override
    public void clear() {
        this.fileAccess.updateFile(new Runnable(){

            public void run() {
                LockingBlockStore.this.store.clear();
            }
        });
    }

    @Override
    public void attach(BlockPayload block) {
        this.store.attach(block);
    }

    @Override
    public <T extends BlockPayload> T read(final BlockPointer pos, final Class<T> payloadType) {
        return (T)((BlockPayload)this.fileAccess.readFile(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return LockingBlockStore.this.store.read(pos, payloadType);
            }
        }));
    }

    @Override
    public <T extends BlockPayload> T readFirst(final Class<T> payloadType) {
        return (T)((BlockPayload)this.fileAccess.readFile(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return LockingBlockStore.this.store.readFirst(payloadType);
            }
        }));
    }

    @Override
    public void write(final BlockPayload block) {
        this.fileAccess.updateFile(new Runnable(){

            public void run() {
                LockingBlockStore.this.store.write(block);
            }
        });
    }

    @Override
    public void remove(final BlockPayload block) {
        this.fileAccess.updateFile(new Runnable(){

            public void run() {
                LockingBlockStore.this.store.remove(block);
            }
        });
    }
}

