/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ScriptBlock;
import org.gradle.groovy.scripts.internal.StatementTransformer;
import org.gradle.internal.Factory;
import org.gradle.plugin.use.internal.PluginRequests;
import org.gradle.plugin.use.internal.PluginUseScriptBlockMetadataExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialPassStatementTransformer
implements StatementTransformer,
Factory<PluginRequests> {
    public static final String PLUGINS = "plugins";
    private final String classpathBlockName;
    private final String pluginsBlockMessage;
    private final PluginUseScriptBlockMetadataExtractor pluginBlockMetadataExtractor;
    private boolean seenNonClasspathStatement;
    private boolean seenPluginsBlock;
    private final List<String> scriptBlockNames;

    public InitialPassStatementTransformer(String classpathBlockName, String pluginsBlockMessage, ScriptSource scriptSource, DocumentationRegistry documentationRegistry) {
        this.classpathBlockName = classpathBlockName;
        this.scriptBlockNames = Arrays.asList(classpathBlockName, PLUGINS);
        this.pluginsBlockMessage = pluginsBlockMessage;
        this.pluginBlockMetadataExtractor = new PluginUseScriptBlockMetadataExtractor(scriptSource, documentationRegistry);
    }

    public Statement transform(SourceUnit sourceUnit, Statement statement) {
        ScriptBlock scriptBlock = AstUtils.detectScriptBlock((Statement)statement, this.scriptBlockNames);
        if (scriptBlock == null) {
            this.seenNonClasspathStatement = true;
            return null;
        }
        if (scriptBlock.getName().equals(PLUGINS)) {
            String failMessage = null;
            if (this.pluginsBlockMessage != null) {
                failMessage = this.pluginBlockMetadataExtractor.formatErrorMessage(this.pluginsBlockMessage);
            } else {
                this.seenPluginsBlock = true;
                if (this.seenNonClasspathStatement) {
                    failMessage = String.format(this.pluginBlockMetadataExtractor.formatErrorMessage("only %s {} and other %s {} script blocks are allowed before %s {} blocks, no other statements are allowed"), this.classpathBlockName, PLUGINS, PLUGINS);
                } else {
                    this.pluginBlockMetadataExtractor.extract(sourceUnit, scriptBlock);
                }
            }
            if (failMessage != null) {
                sourceUnit.getErrorCollector().addError(new SyntaxException(failMessage, statement.getLineNumber(), statement.getColumnNumber()), sourceUnit);
            }
            return null;
        }
        if (this.seenPluginsBlock) {
            String message = String.format(this.pluginBlockMetadataExtractor.formatErrorMessage("all %s {} blocks must appear before any %s {} blocks in the script"), this.classpathBlockName, PLUGINS);
            sourceUnit.getErrorCollector().addError(new SyntaxException(message, statement.getLineNumber(), statement.getColumnNumber()), sourceUnit);
        }
        return statement;
    }

    public PluginRequests create() {
        return this.pluginBlockMetadataExtractor.getRequests();
    }
}

