/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.messaging.remote.internal.PlaceholderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Message.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(Object message, OutputStream outputSteam) throws IOException {
        ExceptionReplacingObjectOutputStream oos = new ExceptionReplacingObjectOutputStream(outputSteam);
        try {
            oos.writeObject(message);
        }
        finally {
            oos.flush();
        }
    }

    public static Object receive(InputStream inputSteam, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        ExceptionReplacingObjectInputStream ois = new ExceptionReplacingObjectInputStream(inputSteam, classLoader);
        return ((ObjectInputStream)((Object)ois)).readObject();
    }

    private static class ExceptionReplacingObjectInputStream
    extends ClassLoaderObjectInputStream {
        public ExceptionReplacingObjectInputStream(InputStream inputSteam, ClassLoader classLoader) throws IOException {
            super(inputSteam, classLoader);
            this.enableResolveObject(true);
        }

        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof TopLevelExceptionPlaceholder) {
                return ((ExceptionPlaceholder)obj).read(this.getClassLoader());
            }
            return obj;
        }
    }

    private static class ExceptionReplacingObjectOutputStream
    extends ObjectOutputStream {
        public ExceptionReplacingObjectOutputStream(OutputStream outputSteam) throws IOException {
            super(outputSteam);
            this.enableReplaceObject(true);
        }

        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof Throwable) {
                return new TopLevelExceptionPlaceholder((Throwable)obj);
            }
            return obj;
        }
    }

    private static class TopLevelExceptionPlaceholder
    extends ExceptionPlaceholder {
        private TopLevelExceptionPlaceholder(Throwable throwable) throws IOException {
            super(throwable);
        }
    }

    private static class CausePlaceholder
    implements Serializable {
        private CausePlaceholder() {
        }
    }

    private static class ExceptionPlaceholder
    implements Serializable {
        private final String type;
        private byte[] serializedException;
        private String message;
        private String toString;
        private ExceptionPlaceholder cause;
        private StackTraceElement[] stackTrace;
        private Throwable toStringRuntimeExec;
        private Throwable getMessageExec;

        public ExceptionPlaceholder(Throwable throwable) throws IOException {
            Throwable causeTmp;
            this.type = throwable.getClass().getName();
            try {
                this.stackTrace = throwable.getStackTrace();
            }
            catch (Throwable ignored) {
                this.stackTrace = new StackTraceElement[0];
            }
            try {
                this.message = throwable.getMessage();
            }
            catch (Throwable failure) {
                this.getMessageExec = failure;
            }
            try {
                this.toString = throwable.toString();
            }
            catch (Throwable failure) {
                this.toStringRuntimeExec = failure;
            }
            try {
                causeTmp = throwable.getCause();
            }
            catch (Throwable ignored) {
                causeTmp = null;
            }
            final Throwable causeFinal = causeTmp;
            ByteArrayOutputStream outstr = new ByteArrayOutputStream();
            ExceptionReplacingObjectOutputStream oos = new ExceptionReplacingObjectOutputStream(outstr){
                boolean seenFirst;

                protected Object replaceObject(Object obj) throws IOException {
                    if (!this.seenFirst) {
                        this.seenFirst = true;
                        return obj;
                    }
                    if (obj == causeFinal) {
                        return new CausePlaceholder();
                    }
                    return super.replaceObject(obj);
                }
            };
            try {
                oos.writeObject(throwable);
                oos.close();
                this.serializedException = outstr.toByteArray();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            if (causeFinal != null) {
                this.cause = new ExceptionPlaceholder(causeFinal);
            }
        }

        public Throwable read(ClassLoader classLoader) throws IOException {
            final Throwable causeThrowable = this.getCause(classLoader);
            if (this.serializedException != null) {
                ExceptionReplacingObjectInputStream ois = new ExceptionReplacingObjectInputStream(new ByteArrayInputStream(this.serializedException), classLoader){

                    protected Object resolveObject(Object obj) throws IOException {
                        if (obj instanceof CausePlaceholder) {
                            return causeThrowable;
                        }
                        return super.resolveObject(obj);
                    }
                };
                try {
                    return (Throwable)ois.readObject();
                }
                catch (ClassNotFoundException ignored) {
                }
                catch (Throwable failure) {
                    LOGGER.debug("Ignoring failure to de-serialize throwable.", failure);
                }
            }
            try {
                Constructor<?> constructor = classLoader.loadClass(this.type).getConstructor(String.class);
                Throwable reconstructed = (Throwable)constructor.newInstance(this.message);
                reconstructed.initCause(causeThrowable);
                reconstructed.setStackTrace(this.stackTrace);
                return reconstructed;
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (NoSuchMethodException ignored) {
            }
            catch (Throwable ignored) {
                LOGGER.debug("Ignoring failure to recreate throwable.", ignored);
            }
            PlaceholderException placeholder = new PlaceholderException(this.type, this.message, this.getMessageExec, this.toString, this.toStringRuntimeExec, causeThrowable);
            placeholder.setStackTrace(this.stackTrace);
            return placeholder;
        }

        private Throwable getCause(ClassLoader classLoader) throws IOException {
            return this.cause != null ? this.cause.read(classLoader) : null;
        }
    }
}

