/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.ipc.basic;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.foundation.ipc.basic.MessageObject;
import org.gradle.foundation.ipc.basic.ObjectSocketWrapper;

public class ClientProcess {
    private final Logger logger = Logging.getLogger(ClientProcess.class);
    private ObjectSocketWrapper socketWrapper;
    private Protocol protocol;

    public ClientProcess(Protocol protocol) {
        this.protocol = protocol;
        protocol.initialize(this);
    }

    public void start(int port) {
        Socket clientSocket;
        try {
            clientSocket = new Socket((String)null, port);
            this.socketWrapper = new ObjectSocketWrapper(clientSocket);
            if (this.protocol.serverConnected(clientSocket)) {
                return;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Could not connect to GUI server at port %s.", port), (Throwable)e);
        }
        try {
            clientSocket.close();
            this.socketWrapper = null;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        throw new UncheckedIOException("GUI protocol failed to connect.");
    }

    public void stop() {
        if (this.socketWrapper != null) {
            this.socketWrapper.close();
        }
    }

    public boolean sendMessage(String messageType, String message, Serializable data) {
        return this.socketWrapper.sendObject(new MessageObject(messageType, message, data));
    }

    public boolean sendMessage(String messageType, String message) {
        return this.sendMessage(messageType, message, null);
    }

    public MessageObject sendMessageWaitForReply(String messageType, String message, Serializable data) {
        if (!this.socketWrapper.sendObject(new MessageObject(messageType, message, data))) {
            return null;
        }
        return this.readMessage();
    }

    public MessageObject readMessage() {
        Object object = this.socketWrapper.readObject();
        if (object == null) {
            return null;
        }
        if (object instanceof MessageObject) {
            return (MessageObject)object;
        }
        return new MessageObject("?", object.toString(), null);
    }

    public static interface Protocol {
        public void initialize(ClientProcess var1);

        public boolean serverConnected(Socket var1);

        public boolean continueConnection();
    }
}

