/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.gradle.BuildResult;
import org.gradle.foundation.ipc.gradle.ExecuteGradleCommandServerProtocol;
import org.gradle.foundation.output.FileLink;
import org.gradle.foundation.output.FileLinkDefinitionLord;
import org.gradle.gradleplugin.foundation.GradlePluginLord;
import org.gradle.gradleplugin.foundation.favorites.FavoriteTask;
import org.gradle.gradleplugin.foundation.request.RefreshTaskListRequest;
import org.gradle.gradleplugin.foundation.request.Request;
import org.gradle.gradleplugin.userinterface.AlternateUIInteraction;
import org.gradle.gradleplugin.userinterface.swing.common.SearchPanel;
import org.gradle.gradleplugin.userinterface.swing.common.TextPaneSearchInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.OutputTextPane;
import org.gradle.gradleplugin.userinterface.swing.generic.SwingEditFavoriteInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.Utility;
import org.gradle.logging.ShowStacktrace;

public class OutputPanel
extends JPanel
implements ExecuteGradleCommandServerProtocol.ExecutionInteraction {
    private GradlePluginLord gradlePluginLord;
    private OutputPanelParent parent;
    private AlternateUIInteraction alternateUIInteraction;
    private JPanel gradleOutputTextPanel;
    private OutputTextPane gradleOutputTextPane;
    private JPanel progressPanel;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private JPanel statusPanel;
    private JLabel statusLabel;
    private JButton executeAgainButton;
    private JButton stopButton;
    private JButton findButton;
    private JToggleButton pinButton;
    private JButton addToFavoritesButton;
    private JPanel linkNavigationPanel;
    private JLabel forceShowOutputButtonLabel;
    private SearchPanel searchPanel;
    private boolean isBusy;
    private boolean isPending;
    private boolean isPinned;
    private boolean showProgress = true;
    private boolean onlyShowOutputOnErrors;
    private boolean wasStopped;
    private Request request;
    private JButton nextLinkButton;
    private JButton previousLinkButton;

    public OutputPanel(GradlePluginLord gradlePluginLord, OutputPanelParent parent, AlternateUIInteraction alternateUIInteraction) {
        this.gradlePluginLord = gradlePluginLord;
        this.parent = parent;
        this.alternateUIInteraction = alternateUIInteraction;
    }

    public void initialize() {
        this.setupUI();
    }

    public void setRequest(Request request, boolean onlyShowOutputOnErrors) {
        this.request = request;
        if (request.forceOutputToBeShown()) {
            this.setOnlyShowOutputOnErrors(false);
        } else {
            this.setOnlyShowOutputOnErrors(onlyShowOutputOnErrors);
        }
        this.enableAddToFavoritesAppropriately();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(false);
        this.setPending(true);
        this.showProgress(true);
        this.appendGradleOutput(this.getPrefixText());
    }

    private String getPrefixText() {
        return "Executing command: \"" + this.request.getFullCommandLine() + "\"\n";
    }

    public boolean isPinned() {
        return this.isPinned;
    }

    public void setPinned(boolean pinned) {
        this.isPinned = pinned;
        this.pinButton.setSelected(this.isPinned);
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    protected void setBusy(boolean busy) {
        this.isBusy = busy;
    }

    public boolean isPending() {
        return this.isPending;
    }

    private void setPending(boolean pending) {
        this.isPending = pending;
        if (this.isPending) {
            this.statusLabel.setText("Waiting to execute");
        }
        this.progressBar.setVisible(!this.isPending);
    }

    public Request getRequest() {
        return this.request;
    }

    private void setupUI() {
        this.setLayout(new BorderLayout());
        this.add(this.createSideOptionsPanel(), "West");
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.add((Component)centerPanel, "Center");
        centerPanel.add(this.createGradleOutputPanel(), "Center");
        centerPanel.add(this.createInfoPanel(), "North");
        centerPanel.add(this.createSearchPanel(), "South");
    }

    private Component createGradleOutputPanel() {
        this.gradleOutputTextPanel = new JPanel(new BorderLayout());
        this.gradleOutputTextPane = new OutputTextPane(new OutputTextPane.Interaction(){

            public void fileClicked(File file, int line) {
                OutputPanel.this.alternateUIInteraction.openFile(file, line);
            }
        }, this.alternateUIInteraction.doesSupportEditingOpeningFiles(), this.getFont(), this.parent.getFileLinkDefinitionLord());
        this.gradleOutputTextPanel.add((Component)this.gradleOutputTextPane.asComponent(), "Center");
        return this.gradleOutputTextPanel;
    }

    private Component createInfoPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.createStatusPanel());
        panel.add(this.createProgressPanel());
        return panel;
    }

    private Component createProgressPanel() {
        this.progressPanel = new JPanel(new BorderLayout());
        this.progressLabel = new JLabel("Progress");
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressPanel.add((Component)this.progressBar, "North");
        this.progressPanel.add((Component)this.progressLabel, "South");
        this.progressPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.progressPanel.setVisible(false);
        return this.progressPanel;
    }

    private Component createStatusPanel() {
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 0));
        this.statusLabel = new JLabel();
        this.forceShowOutputButtonLabel = new JLabel("Show Output");
        this.forceShowOutputButtonLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                OutputPanel.this.forciblyShowOutput();
            }

            public void mouseEntered(MouseEvent e) {
                OutputPanel.this.forceShowOutputButtonLabel.setForeground(UIManager.getColor("textHighlightText"));
            }

            public void mouseExited(MouseEvent e) {
                OutputPanel.this.forceShowOutputButtonLabel.setForeground(UIManager.getColor("Label.foreground"));
            }
        });
        this.statusPanel.add(this.statusLabel);
        this.statusPanel.add(Box.createHorizontalGlue());
        this.statusPanel.add(this.forceShowOutputButtonLabel);
        this.statusPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return this.statusPanel;
    }

    private Component createSideOptionsPanel() {
        this.executeAgainButton = Utility.createButton(OutputPanel.class, "/org/gradle/gradleplugin/userinterface/swing/generic/tabs/execute.png", "Execute again", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.parent.executeAgain(OutputPanel.this.request, OutputPanel.this);
            }
        });
        this.executeAgainButton.setEnabled(false);
        this.stopButton = Utility.createButton(OutputPanel.class, "/org/gradle/gradleplugin/userinterface/swing/generic/stop.png", "Stop executing", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.stop();
            }
        });
        this.stopButton.setEnabled(true);
        this.findButton = Utility.createButton(OutputPanel.class, "/org/gradle/gradleplugin/userinterface/swing/generic/find.png", "Find in output", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.searchPanel.show();
            }
        });
        this.pinButton = Utility.createToggleButton(OutputPanel.class, "/org/gradle/gradleplugin/userinterface/swing/generic/pin.png", "Pin this output tab", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.setPinned(!OutputPanel.this.isPinned);
            }
        });
        this.addToFavoritesButton = Utility.createButton(OutputPanel.class, "/org/gradle/gradleplugin/userinterface/swing/generic/add-favorite.png", "Add to favorites", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.addToFavorites();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        panel.add(this.executeAgainButton);
        panel.add(Box.createVerticalStrut(5));
        panel.add(this.stopButton);
        panel.add(Box.createVerticalStrut(10));
        panel.add(this.pinButton);
        panel.add(Box.createVerticalStrut(10));
        panel.add(this.findButton);
        panel.add(Box.createVerticalStrut(10));
        panel.add(this.createLinkNavigationOptions());
        panel.add(this.addToFavoritesButton);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private Component createLinkNavigationOptions() {
        this.linkNavigationPanel = new JPanel();
        this.linkNavigationPanel.setLayout(new BoxLayout(this.linkNavigationPanel, 1));
        this.nextLinkButton = Utility.createButton(this.getClass(), "/org/gradle/gradleplugin/userinterface/swing/generic/next-link.png", "Go to the next link", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.goToNextLink();
            }
        });
        this.previousLinkButton = Utility.createButton(this.getClass(), "/org/gradle/gradleplugin/userinterface/swing/generic/previous-link.png", "Go to the previous link", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.goToPreviousLink();
            }
        });
        this.linkNavigationPanel.add(this.previousLinkButton);
        this.linkNavigationPanel.add(Box.createVerticalStrut(5));
        this.linkNavigationPanel.add(this.nextLinkButton);
        this.linkNavigationPanel.add(Box.createVerticalStrut(10));
        if (!this.alternateUIInteraction.doesSupportEditingOpeningFiles()) {
            this.linkNavigationPanel.setVisible(false);
        }
        return this.linkNavigationPanel;
    }

    private Component createSearchPanel() {
        StyleContext styleContent = StyleContext.getDefaultStyleContext();
        AttributeSet highlightStyle = this.gradleOutputTextPane.getDefaultStyle().copyAttributes();
        highlightStyle = styleContent.addAttribute(highlightStyle, StyleConstants.Foreground, Color.white);
        highlightStyle = styleContent.addAttribute(highlightStyle, StyleConstants.Background, Color.orange);
        highlightStyle = styleContent.addAttribute(highlightStyle, StyleConstants.Underline, true);
        AttributeSet emphasizedHighlightStyle = highlightStyle.copyAttributes();
        emphasizedHighlightStyle = styleContent.addAttribute(emphasizedHighlightStyle, StyleConstants.Foreground, Color.black);
        emphasizedHighlightStyle = styleContent.addAttribute(emphasizedHighlightStyle, StyleConstants.Background, Color.yellow);
        this.searchPanel = new SearchPanel(new OutputPanelSearchInteraction(this.gradleOutputTextPane.getTextComponent(), this.gradleOutputTextPane.getDefaultStyle(), highlightStyle, emphasizedHighlightStyle));
        this.searchPanel.hide();
        return this.searchPanel.getComponent();
    }

    private void goToNextLink() {
        FileLink fileLink = this.gradleOutputTextPane.getNextFileLink();
        this.gradleOutputTextPane.selectFileLink(fileLink);
    }

    private void goToPreviousLink() {
        FileLink fileLink = this.gradleOutputTextPane.getPreviousFileLink();
        this.gradleOutputTextPane.selectFileLink(fileLink);
    }

    public void reset() {
        this.executeAgainButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.statusLabel.setText("");
        this.statusLabel.setForeground(UIManager.getColor("Label.foreground"));
        this.gradleOutputTextPane.setText("");
        this.progressLabel.setText("");
        this.wasStopped = false;
        this.searchPanel.hide();
        this.previousLinkButton.setEnabled(false);
        this.nextLinkButton.setEnabled(false);
    }

    private void appendGradleOutput(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OutputPanel.this.gradleOutputTextPane.appendText(text);
                OutputPanel.this.updateLinkNavigationOptions();
            }
        });
    }

    private void setProgress(final String text, final float percentComplete) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OutputPanel.this.progressBar.setValue((int)percentComplete);
                OutputPanel.this.progressLabel.setText(text);
            }
        });
    }

    public void reportExecutionStarted() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OutputPanel.this.setPending(false);
                OutputPanel.this.setBusy(true);
                OutputPanel.this.setProgress("Starting", 0.0f);
                if (OutputPanel.this.showProgress) {
                    OutputPanel.this.progressPanel.setVisible(true);
                }
                OutputPanel.this.statusLabel.setText("Executing");
                OutputPanel.this.forceShowOutputButtonLabel.setVisible(OutputPanel.this.onlyShowOutputOnErrors);
            }
        });
    }

    public void reportNumberOfTasksToExecute(final int size) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean isIndeterminate = size == 1;
                OutputPanel.this.progressBar.setIndeterminate(isIndeterminate);
                OutputPanel.this.progressBar.setStringPainted(!isIndeterminate);
            }
        });
    }

    public void reportExecutionFinished(boolean wasSuccessful, BuildResult buildResult, String output) {
        this.reportExecutionFinished(wasSuccessful, output, buildResult.getFailure());
    }

    public void reportExecutionFinished(final boolean wasSuccessful, final String output, final Throwable throwable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OutputPanel.this.setPending(false);
                OutputPanel.this.setBusy(false);
                OutputPanel.this.progressPanel.setVisible(false);
                String newText = OutputPanel.this.getPrefixText() + output;
                OutputPanel.this.gradleOutputTextPane.setText(newText);
                SimpleDateFormat formatter = new SimpleDateFormat("h:mm:ss aa");
                String formattedTime = formatter.format(Calendar.getInstance().getTime());
                if (wasSuccessful) {
                    OutputPanel.this.statusLabel.setText("Completed successfully at " + formattedTime);
                    OutputPanel.this.appendGradleOutput("\nCompleted Successfully");
                } else {
                    if (OutputPanel.this.wasStopped) {
                        OutputPanel.this.statusLabel.setText("User stopped execution at " + formattedTime);
                    } else {
                        OutputPanel.this.statusLabel.setText("Completed with errors at " + formattedTime);
                    }
                    OutputPanel.this.statusLabel.setForeground(Color.red.darker());
                    OutputPanel.this.gradleOutputTextPanel.setVisible(true);
                }
                OutputPanel.this.executeAgainButton.setEnabled(true);
                OutputPanel.this.stopButton.setEnabled(false);
                OutputPanel.this.appendThrowable(throwable);
                OutputPanel.this.forceShowOutputButtonLabel.setVisible(!OutputPanel.this.gradleOutputTextPanel.isVisible());
                OutputPanel.this.updateLinkNavigationOptions();
                OutputPanel.this.searchPanel.performSearchAgain();
                OutputPanel.this.parent.reportExecuteFinished(OutputPanel.this.request, wasSuccessful);
            }
        });
    }

    private void appendThrowable(Throwable throwable) {
        if (throwable != null) {
            String output = GradlePluginLord.getGradleExceptionMessage(throwable, ShowStacktrace.ALWAYS_FULL);
            this.appendGradleOutput(output);
        }
    }

    public void reportTaskStarted(String currentTaskName, float percentComplete) {
        this.setProgress(currentTaskName, percentComplete);
    }

    public void reportTaskComplete(String currentTaskName, float percentComplete) {
        this.setProgress(currentTaskName, percentComplete);
    }

    public void reportFatalError(String message) {
        this.appendGradleOutput('\n' + message + "\n\nFailed.\n");
    }

    public void reportLiveOutput(String output) {
        this.appendGradleOutput(output);
    }

    public boolean canBeReusedNow() {
        return !this.isPending && !this.isBusy && !this.isPinned;
    }

    private void showProgress(boolean showProgress) {
        this.showProgress = showProgress;
        this.progressPanel.setVisible(showProgress);
    }

    private void forciblyShowOutput() {
        this.gradleOutputTextPanel.setVisible(true);
        this.forceShowOutputButtonLabel.setVisible(false);
    }

    public void setOnlyShowOutputOnErrors(boolean value) {
        this.onlyShowOutputOnErrors = value;
        this.gradleOutputTextPanel.setVisible(!value);
    }

    public boolean getOnlyShowOutputOnErrors() {
        return this.onlyShowOutputOnErrors;
    }

    public boolean close() {
        if (!this.stop()) {
            return false;
        }
        this.parent.removeOutputPanel(this);
        this.setPinned(false);
        return true;
    }

    public boolean stop() {
        if (this.request != null && !this.request.cancel()) {
            return false;
        }
        this.wasStopped = true;
        return true;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.gradleOutputTextPane != null) {
            this.gradleOutputTextPane.setFont(font);
        }
    }

    private void updateLinkNavigationOptions() {
        if (this.gradleOutputTextPane.hasClickableLinks()) {
            this.nextLinkButton.setEnabled(true);
            this.previousLinkButton.setEnabled(true);
        } else {
            this.nextLinkButton.setEnabled(false);
            this.previousLinkButton.setEnabled(false);
        }
    }

    private void addToFavorites() {
        if (this.request == null) {
            return;
        }
        String fullCommandLine = this.request.getFullCommandLine();
        String displayName = this.request.getDisplayName();
        FavoriteTask favoriteTask = this.gradlePluginLord.getFavoritesEditor().addFavorite(fullCommandLine, displayName, false);
        if (favoriteTask != null) {
            this.gradlePluginLord.getFavoritesEditor().editFavorite(favoriteTask, new SwingEditFavoriteInteraction(SwingUtilities.getWindowAncestor(this), "Edit Favorite", SwingEditFavoriteInteraction.SynchronizeType.OnlyIfAlreadySynchronized));
            this.enableAddToFavoritesAppropriately();
        }
    }

    private void enableAddToFavoritesAppropriately() {
        boolean isVisible = true;
        if (this.request == null) {
            isVisible = false;
        } else if (this.request.getType() == RefreshTaskListRequest.TYPE) {
            isVisible = false;
        } else if (this.gradlePluginLord.getFavoritesEditor().getFavorite(this.request.getFullCommandLine()) != null) {
            isVisible = false;
        }
        this.addToFavoritesButton.setVisible(isVisible);
    }

    private class OutputPanelSearchInteraction
    extends TextPaneSearchInteraction {
        private OutputPanelSearchInteraction(JTextPane textComponentToSearch, AttributeSet defaultStyle, AttributeSet highlightStyle, AttributeSet emphasizedHighlightStyle) {
            super(textComponentToSearch, defaultStyle, highlightStyle, emphasizedHighlightStyle);
        }

        public void removeResultHighlights() {
            OutputPanel.this.gradleOutputTextPane.resetHighlights();
        }
    }

    public static interface OutputPanelParent {
        public void removeOutputPanel(OutputPanel var1);

        public void reportExecuteFinished(Request var1, boolean var2);

        public void executeAgain(Request var1, OutputPanel var2);

        public FileLinkDefinitionLord getFileLinkDefinitionLord();
    }
}

