/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.internal.typeconversion;

import org.gradle.testkit.jarjar.org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.testkit.jarjar.org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.testkit.jarjar.org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.testkit.jarjar.org.gradle.internal.typeconversion.NotationParser;
import org.gradle.testkit.jarjar.org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.testkit.jarjar.org.gradle.internal.typeconversion.UnsupportedNotationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotationConverterToNotationParserAdapter<N, T>
implements NotationParser<N, T> {
    private final NotationConverter<N, ? extends T> converter;

    public NotationConverterToNotationParserAdapter(NotationConverter<N, ? extends T> converter) {
        this.converter = converter;
    }

    @Override
    public T parseNotation(N notation) throws TypeConversionException {
        ResultImpl result = new ResultImpl();
        this.converter.convert(notation, result);
        if (!result.hasResult) {
            throw new UnsupportedNotationException(notation);
        }
        return (T)result.result;
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        this.converter.describe(visitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultImpl<T>
    implements NotationConvertResult<T> {
        private boolean hasResult;
        private T result;

        private ResultImpl() {
        }

        @Override
        public boolean hasResult() {
            return this.hasResult;
        }

        @Override
        public void converted(T result) {
            this.hasResult = true;
            this.result = result;
        }
    }
}

