/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.plugins;

import java.io.File;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.artifact.MavenArtifactNotationParserFactory;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenProjectIdentity;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.publish.maven.tasks.PublishToMavenLocal;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class MavenPublishPlugin
implements Plugin<Project> {
    public static final String PUBLISH_LOCAL_LIFECYCLE_TASK_NAME = "publishToMavenLocal";
    private final Instantiator instantiator;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final FileCollectionFactory fileCollectionFactory;

    @Inject
    public MavenPublishPlugin(Instantiator instantiator, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory) {
        this.instantiator = instantiator;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
        this.projectDependencyResolver = projectDependencyResolver;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        TaskContainer tasks = project.getTasks();
        Task publishLocalLifecycleTask = tasks.create(PUBLISH_LOCAL_LIFECYCLE_TASK_NAME);
        publishLocalLifecycleTask.setDescription("Publishes all Maven publications produced by this project to the local Maven cache.");
        publishLocalLifecycleTask.setGroup("publishing");
        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

            public void execute(PublishingExtension extension) {
                extension.getPublications().registerFactory(MavenPublication.class, (NamedDomainObjectFactory)new MavenPublicationFactory(MavenPublishPlugin.this.dependencyMetaDataProvider, MavenPublishPlugin.this.instantiator, MavenPublishPlugin.this.fileResolver));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MavenPublicationFactory
    implements NamedDomainObjectFactory<MavenPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final FileResolver fileResolver;

        private MavenPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, FileResolver fileResolver) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.fileResolver = fileResolver;
        }

        public MavenPublication create(String name) {
            ModuleInternal module = this.dependencyMetaDataProvider.getModule();
            DefaultMavenProjectIdentity projectIdentity = new DefaultMavenProjectIdentity(module.getGroup(), module.getName(), module.getVersion());
            NotationParser<Object, MavenArtifact> artifactNotationParser = new MavenArtifactNotationParserFactory(this.instantiator, this.fileResolver).create();
            return (MavenPublication)this.instantiator.newInstance(DefaultMavenPublication.class, new Object[]{name, projectIdentity, artifactNotationParser, this.instantiator, MavenPublishPlugin.this.projectDependencyResolver, MavenPublishPlugin.this.fileCollectionFactory});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Mutate
        public void realizePublishingTasks(ModelMap<Task> tasks, PublishingExtension extension, @Path(value="buildDir") File buildDir) {
            PublicationContainer publications = extension.getPublications();
            Task publishLifecycleTask = (Task)tasks.get("publish");
            Task publishLocalLifecycleTask = (Task)tasks.get(MavenPublishPlugin.PUBLISH_LOCAL_LIFECYCLE_TASK_NAME);
            for (MavenPublicationInternal publication : publications.withType(MavenPublicationInternal.class)) {
                String publicationName = publication.getName();
                this.createGeneratePomTask(tasks, publication, publicationName, buildDir);
                this.createLocalInstallTask(tasks, publishLocalLifecycleTask, publication, publicationName);
                this.createPublishTasksForEachMavenRepo(tasks, extension, publishLifecycleTask, publication, publicationName);
            }
        }

        private void createPublishTasksForEachMavenRepo(ModelMap<Task> tasks, PublishingExtension extension, Task publishLifecycleTask, final MavenPublicationInternal publication, final String publicationName) {
            for (final MavenArtifactRepository repository : extension.getRepositories().withType(MavenArtifactRepository.class)) {
                final String repositoryName = repository.getName();
                String publishTaskName = String.format("publish%sPublicationTo%sRepository", StringUtils.capitalize((String)publicationName), StringUtils.capitalize((String)repositoryName));
                tasks.create(publishTaskName, PublishToMavenRepository.class, (Action)new Action<PublishToMavenRepository>(){

                    public void execute(PublishToMavenRepository publishTask) {
                        publishTask.setPublication(publication);
                        publishTask.setRepository(repository);
                        publishTask.setGroup("publishing");
                        publishTask.setDescription(String.format("Publishes Maven publication '%s' to Maven repository '%s'.", publicationName, repositoryName));
                    }
                });
                publishLifecycleTask.dependsOn(new Object[]{publishTaskName});
            }
        }

        private void createLocalInstallTask(ModelMap<Task> tasks, Task publishLocalLifecycleTask, final MavenPublicationInternal publication, final String publicationName) {
            String installTaskName = String.format("publish%sPublicationToMavenLocal", StringUtils.capitalize((String)publicationName));
            tasks.create(installTaskName, PublishToMavenLocal.class, (Action)new Action<PublishToMavenLocal>(){

                public void execute(PublishToMavenLocal publishLocalTask) {
                    publishLocalTask.setPublication(publication);
                    publishLocalTask.setGroup("publishing");
                    publishLocalTask.setDescription(String.format("Publishes Maven publication '%s' to the local Maven repository.", publicationName));
                }
            });
            publishLocalLifecycleTask.dependsOn(new Object[]{installTaskName});
        }

        private void createGeneratePomTask(ModelMap<Task> tasks, final MavenPublicationInternal publication, String publicationName, final File buildDir) {
            String descriptorTaskName = String.format("generatePomFileFor%sPublication", StringUtils.capitalize((String)publicationName));
            tasks.create(descriptorTaskName, GenerateMavenPom.class, (Action)new Action<GenerateMavenPom>(){

                public void execute(GenerateMavenPom generatePomTask) {
                    generatePomTask.setDescription(String.format("Generates the Maven POM file for publication '%s'.", publication.getName()));
                    generatePomTask.setGroup("publishing");
                    generatePomTask.setPom(publication.getPom());
                    generatePomTask.setDestination(new File(buildDir, "publications/" + publication.getName() + "/pom-default.xml"));
                }
            });
            publication.setPomFile(((Task)tasks.get(descriptorTaskName)).getOutputs().getFiles());
        }
    }
}

