/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.upload.UploadNotesTask;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class UploadNotesAction
extends JosmAction {
    public UploadNotesAction() {
        this.putValue("ShortDescription", I18n.tr("Upload note changes to server", new Object[0]));
        this.putValue("Name", I18n.tr("Upload notes", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("upload"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        NoteData noteData;
        List<NoteLayer> list = null;
        if (Main.map != null) {
            list = Main.map.mapView.getLayersOfType(NoteLayer.class);
        }
        if (list == null || list.isEmpty()) {
            Main.error("No note layer found");
            return;
        }
        NoteLayer noteLayer = list.get(0);
        if (Main.isDebugEnabled()) {
            Main.debug("uploading note changes");
        }
        if ((noteData = noteLayer.getNoteData()) == null || !noteData.isModified()) {
            if (Main.isDebugEnabled()) {
                Main.debug("No changed notes to upload");
            }
            return;
        }
        new UploadNotesTask().uploadNotes(noteData, new PleaseWaitProgressMonitor(I18n.tr("Uploading notes to server", new Object[0])));
    }
}

