/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public class RubiniusSingleBlockArgNode
extends RubyNode {
    private final ConditionProfile emptyArgsProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile singleArgProfile = ConditionProfile.createBinaryProfile();

    public RubiniusSingleBlockArgNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int userArgumentCount = RubyArguments.getArgumentsCount(frame.getArguments());
        if (this.emptyArgsProfile.profile(userArgumentCount == 0)) {
            return this.nil();
        }
        if (this.singleArgProfile.profile(userArgumentCount == 1)) {
            return RubyArguments.getArgument(frame.getArguments(), 0);
        }
        Object[] extractedArguments = RubyArguments.getArguments(frame.getArguments());
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), extractedArguments, userArgumentCount);
    }
}

