/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.hash.HashGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.PackedArrayStrategy;
import org.jruby.truffle.runtime.layouts.Layouts;

public abstract class HashOperations {
    public static boolean verifyStore(RubyContext context, DynamicObject hash) {
        return HashOperations.verifyStore(context, Layouts.HASH.getStore(hash), Layouts.HASH.getSize(hash), Layouts.HASH.getFirstInSequence(hash), Layouts.HASH.getLastInSequence(hash));
    }

    public static boolean verifyStore(RubyContext context, Object store, int size, Entry firstInSequence, Entry lastInSequence) {
        assert (store == null || store.getClass() == Object[].class || store instanceof Entry[]);
        if (store == null) {
            assert (size == 0);
            assert (firstInSequence == null);
            assert (lastInSequence == null);
        } else if (store instanceof Entry[]) {
            Entry entry;
            assert (lastInSequence == null || lastInSequence.getNextInSequence() == null);
            Entry[] entryStore = (Entry[])store;
            Entry foundFirst = null;
            Entry foundLast = null;
            int foundSizeBuckets = 0;
            for (int n = 0; n < entryStore.length; ++n) {
                for (entry = entryStore[n]; entry != null; entry = entry.getNextInLookup()) {
                    ++foundSizeBuckets;
                    if (entry == firstInSequence) {
                        assert (foundFirst == null);
                        foundFirst = entry;
                    }
                    if (entry != lastInSequence) continue;
                    assert (foundLast == null);
                    foundLast = entry;
                }
            }
            assert (foundSizeBuckets == size);
            assert (firstInSequence == foundFirst);
            assert (lastInSequence == foundLast);
            int foundSizeSequence = 0;
            for (entry = firstInSequence; entry != null; entry = entry.getNextInSequence()) {
                ++foundSizeSequence;
                if (entry.getNextInSequence() == null ? !$assertionsDisabled && entry != lastInSequence : !$assertionsDisabled && entry.getNextInSequence().getPreviousInSequence() != entry) {
                    throw new AssertionError();
                }
            }
            assert (foundSizeSequence == size) : String.format("%d %d", foundSizeSequence, size);
        } else if (store.getClass() == Object[].class) {
            assert (((Object[])store).length == context.getOptions().HASH_PACKED_ARRAY_MAX * 3) : ((Object[])store).length;
            Object[] packedStore = (Object[])store;
            for (int n = 0; n < context.getOptions().HASH_PACKED_ARRAY_MAX; ++n) {
                if (n >= size) continue;
                assert (packedStore[n * 2] != null);
                assert (packedStore[n * 2 + 1] != null);
            }
            assert (firstInSequence == null);
            assert (lastInSequence == null);
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static Iterator<Map.Entry<Object, Object>> iterateKeyValues(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        if (HashGuards.isNullHash(hash)) {
            return Collections.emptyIterator();
        }
        if (HashGuards.isPackedHash(hash)) {
            return PackedArrayStrategy.iterateKeyValues((Object[])Layouts.HASH.getStore(hash), Layouts.HASH.getSize(hash));
        }
        if (HashGuards.isBucketHash(hash)) {
            return BucketsStrategy.iterateKeyValues(Layouts.HASH.getFirstInSequence(hash));
        }
        throw new UnsupportedOperationException();
    }

    @CompilerDirectives.TruffleBoundary
    public static Iterable<Map.Entry<Object, Object>> iterableKeyValues(final DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return new Iterable<Map.Entry<Object, Object>>(){

            @Override
            public Iterator<Map.Entry<Object, Object>> iterator() {
                return HashOperations.iterateKeyValues(hash);
            }
        };
    }
}

