/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import org.sejda.common.ComponentsUtility;
import org.sejda.common.LookupTable;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.Annotations;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.SplitDownTheMiddleParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.repaginate.Repagination;
import org.sejda.model.task.BaseTask;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitDownTheMiddleTask
extends BaseTask<SplitDownTheMiddleParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitDownTheMiddleTask.class);
    private int totalSteps;
    private PDDocumentHandler sourceHandler = null;
    private PDDocumentHandler destinationHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    @Override
    public void before(SplitDownTheMiddleParameters parameters) {
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy());
    }

    @Override
    public void execute(SplitDownTheMiddleParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource source : parameters.getSourceList()) {
            this.stopTaskIfCancelled();
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            this.sourceHandler = source.open(this.documentLoader);
            LOG.debug("Done Opening");
            this.sourceHandler.getPermissions().ensurePermission(PdfAccessPermission.COPY_AND_EXTRACT);
            LOG.debug("Done with perms");
            this.destinationHandler = new PDDocumentHandler();
            this.destinationHandler.setVersionOnPDDocument(parameters.getVersion());
            LOG.debug("Done with version");
            this.destinationHandler.initialiseBasedOn(this.sourceHandler.getUnderlyingPDDocument());
            this.destinationHandler.setCompress(parameters.isCompress());
            LOG.debug("Done with init");
            File tmpFile = IOUtils.createTemporaryBuffer();
            LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
            LookupTable<PDPage> lookup = new LookupTable<PDPage>();
            for (int pageNumber = 1; pageNumber <= this.sourceHandler.getNumberOfPages(); ++pageNumber) {
                PDPage page = this.sourceHandler.getPage(pageNumber);
                PDRectangle trimBox = page.getTrimBox();
                if (trimBox.getHeight() <= trimBox.getWidth()) {
                    PDPage leftPage = this.destinationHandler.importPage(page);
                    lookup.addLookupEntry(page, leftPage);
                    PDRectangle leftSide = new PDRectangle();
                    leftSide.setUpperRightY(trimBox.getUpperRightY());
                    leftSide.setUpperRightX(trimBox.getLowerLeftX() + trimBox.getWidth() / 2.0f);
                    leftSide.setLowerLeftY(trimBox.getLowerLeftY());
                    leftSide.setLowerLeftX(trimBox.getLowerLeftX());
                    leftPage.setCropBox(leftSide);
                    leftPage.setTrimBox(leftSide);
                    leftPage.setMediaBox(leftSide);
                    PDPage rightPage = this.destinationHandler.importPage(page);
                    lookup.addLookupEntry(page, rightPage);
                    PDRectangle rightSide = new PDRectangle();
                    rightSide.setUpperRightY(trimBox.getUpperRightY());
                    rightSide.setUpperRightX(trimBox.getUpperRightX());
                    rightSide.setLowerLeftY(trimBox.getLowerLeftY());
                    rightSide.setLowerLeftX(trimBox.getLowerLeftX() + trimBox.getWidth() / 2.0f);
                    rightPage.setCropBox(rightSide);
                    rightPage.setTrimBox(rightSide);
                    rightPage.setMediaBox(rightSide);
                    continue;
                }
                PDPage topPage = this.destinationHandler.importPage(page);
                lookup.addLookupEntry(page, topPage);
                PDRectangle upperSide = new PDRectangle();
                upperSide.setUpperRightY(trimBox.getUpperRightY());
                upperSide.setUpperRightX(trimBox.getUpperRightX());
                upperSide.setLowerLeftY(trimBox.getLowerLeftY() + trimBox.getHeight() / 2.0f);
                upperSide.setLowerLeftX(trimBox.getLowerLeftX());
                topPage.setCropBox(upperSide);
                topPage.setTrimBox(upperSide);
                topPage.setMediaBox(upperSide);
                PDPage bottomPage = this.destinationHandler.importPage(page);
                lookup.addLookupEntry(page, bottomPage);
                PDRectangle lowerSide = new PDRectangle();
                lowerSide.setUpperRightY(trimBox.getLowerLeftY() + trimBox.getHeight() / 2.0f);
                lowerSide.setUpperRightX(trimBox.getUpperRightX());
                lowerSide.setLowerLeftY(trimBox.getLowerLeftY());
                lowerSide.setLowerLeftX(trimBox.getLowerLeftX());
                bottomPage.setCropBox(lowerSide);
                bottomPage.setTrimBox(lowerSide);
                bottomPage.setMediaBox(lowerSide);
            }
            LookupTable<PDAnnotation> annotations = Annotations.processAnnotations(lookup, this.sourceHandler.getUnderlyingPDDocument());
            SignatureClipper.clipSignatures(annotations.values());
            if (parameters.getRepagination() == Repagination.LAST_FIRST) {
                int pages = this.destinationHandler.getNumberOfPages();
                int startStep = pages / 2 % 2;
                int step = startStep == 0 ? 3 : 1;
                for (int i = pages - startStep; i > 0; i -= step) {
                    this.destinationHandler.movePageToDocumentEnd(i);
                    if (step == 1) {
                        step = 3;
                        continue;
                    }
                    step = 1;
                }
            }
            this.destinationHandler.savePDDocument(tmpFile);
            String outName = NameGenerator.nameGenerator(parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(currentStep));
            this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
            this.closeResources();
            ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Text extracted from input documents and written to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        this.closeResources();
    }

    private void closeResources() {
        ComponentsUtility.nullSafeCloseQuietly(this.sourceHandler);
        ComponentsUtility.nullSafeCloseQuietly(this.destinationHandler);
    }
}

