/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.split;

import java.io.File;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.PagesExtractor;
import org.sejda.impl.sambox.component.optimizaton.OptimizationRuler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.outline.OutlineExtractPageDestinations;
import org.sejda.model.parameter.ExtractByOutlineParameters;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageDestinationsLevelPdfExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(PageDestinationsLevelPdfExtractor.class);
    private final OutlineExtractPageDestinations outlineDestinations;
    private final ExtractByOutlineParameters parameters;
    private final PDDocument document;
    private final MultipleOutputWriter outputWriter;

    public PageDestinationsLevelPdfExtractor(PDDocument document, ExtractByOutlineParameters parameters, OutlineExtractPageDestinations outlineDestinations) {
        this.outlineDestinations = outlineDestinations;
        this.parameters = parameters;
        this.document = document;
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy());
    }

    public void extract(NotifiableTaskMetadata taskMetadata) throws TaskException {
        int outputDocumentsCounter = 0;
        try (PagesExtractor extractor = new PagesExtractor(this.document);){
            int totalExtractions = this.outlineDestinations.sections.size();
            if (totalExtractions == 0) {
                throw new TaskExecutionException("No page has been selected for extraction.");
            }
            boolean optimize = new OptimizationRuler(this.parameters.getOptimizationPolicy()).apply(this.document);
            for (int s = 0; s < totalExtractions; ++s) {
                int page;
                taskMetadata.stopTaskIfCancelled();
                OutlineExtractPageDestinations.OutlineItemBoundaries section = this.outlineDestinations.sections.get(s);
                LOG.debug("Starting extracting {} pages {} {}", section.title, section.startPage, section.endPage);
                File tmpFile = IOUtils.createTemporaryPdfBuffer();
                LOG.debug("Created output temporary buffer {}", (Object)tmpFile);
                String outName = NameGenerator.nameGenerator(this.parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().page(page).originalName(this.parameters.getSource().getName()).fileNumber(++outputDocumentsCounter).bookmark(section.title));
                this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
                for (page = section.startPage; page <= section.endPage; ++page) {
                    taskMetadata.stopTaskIfCancelled();
                    LOG.trace("Retaining page {} of the original document", (Object)page);
                    extractor.retain(page, taskMetadata);
                }
                extractor.setVersion(this.parameters.getVersion());
                extractor.setCompress(this.parameters.isCompress());
                if (optimize) {
                    extractor.optimize();
                }
                extractor.save(tmpFile);
                extractor.reset();
                LOG.debug("Ending extracting {}", (Object)section.title);
                ApplicationEventsNotifier.notifyEvent(taskMetadata).stepsCompleted(s).outOf(totalExtractions);
            }
        }
        this.parameters.getOutput().accept(this.outputWriter);
    }
}

