#!/bin/sh

ENABLE_PYTHON=no

PKG_CONFIG_MODULES="glib-2.0 gtk+-2.0 gtksourceview-2.0 \
		    pygobject-2.0 pygtk-2.0 \
		    pygtksourceview-2.0 enchant iso-codes"

echo_padded ()
{
	echo -n "  - $1 "
	N=$(echo -n $1 | wc -m)
	while test $N -le 20
	do
		echo -n " "
		N=`expr $N + 1`
	done
}

if (which gsettings >/dev/null)
then
	echo "GSettings configuration dump:"
	gsettings list-recursively org.mate.pluma
	echo
fi

echo "Active plugins:"
gsettings get org.mate.pluma active-plugins 				\
	| sed -r -e 's/^\[(.*)\]$/\1/' -e 's/, /\n/g'			\
	| sed -e 's/^.*$/  - \0/'
echo

# Manually installed plugins (in $HOME)
if [ -d $HOME/.config/pluma/plugins ]
then
	echo "Plugins in \$HOME:"
	ls $HOME/.config/pluma/plugins/*.pluma-plugin			\
		| sed -r -e 's#.*/([^/]*)\.pluma-plugin$#  - \1#'
else
	echo "No plugin installed in \$HOME."
fi
echo

echo "Module versions:"
if (which pkg-config > /dev/null)
then
	for i in $PKG_CONFIG_MODULES
	do
		echo_padded "`echo -n $i | sed -r -e 's/^(.*)-[0-9]\.[0-9]$/\1/'`"
		pkg-config --modversion $i 2>/dev/null || echo
	done
else
	echo "  pkg-config unavailable"
fi
echo

echo "Python module versions:"
if test "$ENABLE_PYTHON" = "yes"
then
	echo_padded "python"
	python -V 2>&1 | cut -c8-

	echo_padded "pygtk"
	python -c "import gtk, sys; \
		   sys.stdout.write('%d.%d.%d ' % gtk.pygtk_version); \
		   sys.stdout.write('(GTK+ %d.%d.%d)' % gtk.gtk_version)" \
		   2>/dev/null
	echo
else
	echo "  Python support was not enabled at compile time."
fi
echo

