/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetSnapshotsAction
extends TransportMasterNodeAction<GetSnapshotsRequest, GetSnapshotsResponse> {
    private final SnapshotsService snapshotsService;

    @Inject
    public TransportGetSnapshotsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/snapshot/get", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, GetSnapshotsRequest.class);
        this.snapshotsService = snapshotsService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected GetSnapshotsResponse newResponse() {
        return new GetSnapshotsResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(GetSnapshotsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(GetSnapshotsRequest request, ClusterState state, ActionListener<GetSnapshotsResponse> listener) {
        try {
            ArrayList<SnapshotInfo> snapshotInfoBuilder = new ArrayList<SnapshotInfo>();
            if (this.isAllSnapshots(request.snapshots())) {
                List<Snapshot> snapshots = this.snapshotsService.snapshots(request.repository(), request.ignoreUnavailable());
                for (Snapshot snapshot : snapshots) {
                    snapshotInfoBuilder.add(new SnapshotInfo(snapshot));
                }
            } else if (this.isCurrentSnapshots(request.snapshots())) {
                List<Snapshot> snapshots = this.snapshotsService.currentSnapshots(request.repository());
                for (Snapshot snapshot : snapshots) {
                    snapshotInfoBuilder.add(new SnapshotInfo(snapshot));
                }
            } else {
                LinkedHashSet<String> snapshotsToGet = new LinkedHashSet<String>();
                List<Snapshot> snapshots = null;
                for (String snapshotOrPattern : request.snapshots()) {
                    if (!Regex.isSimpleMatchPattern(snapshotOrPattern)) {
                        snapshotsToGet.add(snapshotOrPattern);
                        continue;
                    }
                    if (snapshots == null) {
                        snapshots = this.snapshotsService.snapshots(request.repository(), request.ignoreUnavailable());
                    }
                    for (Snapshot snapshot : snapshots) {
                        if (!Regex.simpleMatch(snapshotOrPattern, snapshot.name())) continue;
                        snapshotsToGet.add(snapshot.name());
                    }
                }
                for (String snapshot : snapshotsToGet) {
                    SnapshotId snapshotId = new SnapshotId(request.repository(), snapshot);
                    snapshotInfoBuilder.add(new SnapshotInfo(this.snapshotsService.snapshot(snapshotId)));
                }
            }
            listener.onResponse(new GetSnapshotsResponse(Collections.unmodifiableList(snapshotInfoBuilder)));
        }
        catch (Throwable t) {
            listener.onFailure(t);
        }
    }

    private boolean isAllSnapshots(String[] snapshots) {
        return snapshots.length == 0 || snapshots.length == 1 && "_all".equalsIgnoreCase(snapshots[0]);
    }

    private boolean isCurrentSnapshots(String[] snapshots) {
        return snapshots.length == 1 && "_current".equalsIgnoreCase(snapshots[0]);
    }
}

